/*
 * Decompiled with CFR 0.152.
 */
package org.mule.amf.impl;

import amf.ProfileName;
import amf.ProfileNames;
import amf.client.AMF;
import amf.client.environment.DefaultEnvironment;
import amf.client.environment.Environment;
import amf.client.model.document.BaseUnit;
import amf.client.model.document.Document;
import amf.client.model.domain.DomainElement;
import amf.client.model.domain.Server;
import amf.client.model.domain.WebApi;
import amf.client.parse.Parser;
import amf.client.render.AmfGraphRenderer;
import amf.client.render.Oas20Renderer;
import amf.client.render.Raml08Renderer;
import amf.client.render.Raml10Renderer;
import amf.client.resolve.Raml10Resolver;
import amf.client.validate.ValidationReport;
import amf.client.validate.ValidationResult;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.mule.amf.impl.DocumentParser;
import org.mule.amf.impl.loader.ExchangeDependencyResourceLoader;
import org.mule.amf.impl.loader.ProvidedResourceLoader;
import org.mule.amf.impl.model.AmfImpl;
import org.mule.amf.impl.parser.rule.ValidationResultImpl;
import org.mule.apikit.common.CommonUtils;
import org.mule.raml.interfaces.ParserType;
import org.mule.raml.interfaces.ParserWrapper;
import org.mule.raml.interfaces.common.RamlUtils;
import org.mule.raml.interfaces.injector.IRamlUpdater;
import org.mule.raml.interfaces.loader.ResourceLoader;
import org.mule.raml.interfaces.model.ApiVendor;
import org.mule.raml.interfaces.model.IRaml;
import org.mule.raml.interfaces.model.api.ApiRef;
import org.mule.raml.interfaces.parser.rule.DefaultValidationReport;
import org.mule.raml.interfaces.parser.rule.IValidationReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParserWrapperAmf
implements ParserWrapper {
    private static final Logger logger = LoggerFactory.getLogger(ParserWrapperAmf.class);
    private final ApiRef apiRef;
    private final Parser parser;
    private final WebApi webApi;
    private final ApiVendor apiVendor;
    private final List<String> references;
    private Document consoleModel;

    private ParserWrapperAmf(ApiRef apiRef, boolean validate) throws ExecutionException, InterruptedException {
        AMF.init().get();
        this.apiRef = apiRef;
        this.parser = ParserWrapperAmf.initParser(apiRef);
        Document document = this.buildDocument(validate);
        this.references = this.getReferences(document.references());
        this.webApi = DocumentParser.getWebApi((BaseUnit)document);
        this.apiVendor = apiRef.getVendor();
    }

    private static Parser initParser(ApiRef apiRef) {
        Environment environment = ParserWrapperAmf.buildEnvironment(apiRef);
        return DocumentParser.getParserForApi(apiRef, environment);
    }

    private List<String> getReferences(List<BaseUnit> references) {
        ArrayList<String> result = new ArrayList<String>();
        this.appendReferences(references, new HashSet<String>(), result);
        return result;
    }

    private void appendReferences(List<BaseUnit> references, Set<String> alreadyAdded, List<String> result) {
        for (BaseUnit reference : references) {
            String id = reference.id();
            if (alreadyAdded.contains(id)) continue;
            String location = reference.location();
            result.add(location);
            alreadyAdded.add(id);
            this.appendReferences(reference.references(), alreadyAdded, result);
        }
    }

    public static ParserWrapperAmf create(ApiRef apiRef, boolean validate) throws Exception {
        return new ParserWrapperAmf(apiRef, validate);
    }

    private static URI getPathAsUri(ApiRef apiRef) {
        try {
            URI uri = new URI(apiRef.getLocation());
            return uri.isAbsolute() ? uri : ParserWrapperAmf.getUriFromFile(apiRef);
        }
        catch (URISyntaxException e) {
            return ParserWrapperAmf.getUriFromFile(apiRef);
        }
    }

    private static URI getUriFromFile(ApiRef apiRef) {
        URI uri;
        String location = apiRef.getLocation();
        if (apiRef.getResourceLoader().isPresent() && (uri = (URI)apiRef.getResourceLoader().map(loader -> loader.getResource(location)).orElse(null)) != null) {
            return uri;
        }
        File file = new File(location);
        if (file.exists()) {
            return file.toURI();
        }
        URL resource = Thread.currentThread().getContextClassLoader().getResource(location);
        if (resource != null) {
            try {
                return resource.toURI();
            }
            catch (URISyntaxException e1) {
                throw new RuntimeException("Couldn't load api in location: " + location);
            }
        }
        throw new RuntimeException("Couldn't load api in location: " + location);
    }

    private static Environment buildEnvironment(ApiRef apiRef) {
        URI uri = ParserWrapperAmf.getPathAsUri(apiRef);
        Environment environment = DefaultEnvironment.apply();
        if (uri.getScheme() != null && uri.getScheme().startsWith("file")) {
            File file = new File(uri);
            String rootDir = file.isDirectory() ? file.getPath() : file.getParent();
            environment = environment.add((amf.client.resource.ResourceLoader)new ExchangeDependencyResourceLoader(rootDir));
        }
        if (apiRef.getResourceLoader().isPresent()) {
            environment = environment.add((amf.client.resource.ResourceLoader)new ProvidedResourceLoader((ResourceLoader)apiRef.getResourceLoader().get()));
        }
        return environment;
    }

    public ApiVendor getApiVendor() {
        return this.apiVendor;
    }

    public ParserType getParserType() {
        return ParserType.AMF;
    }

    public WebApi getWebApi() {
        return this.webApi;
    }

    public void validate() {
        ValidationReport validationReport = this.generateValidationReport();
        if (!validationReport.conforms()) {
            String errorMessge = "Invalid API descriptor -- errors found: " + validationReport.results().size() + "\n\n" + validationReport.results().stream().map(ValidationResult::message).collect(Collectors.joining("\n"));
            throw new RuntimeException(errorMessge);
        }
    }

    public IValidationReport validationReport() {
        ValidationReport validationReport = this.generateValidationReport();
        List results = !validationReport.conforms() ? validationReport.results().stream().map(ValidationResultImpl::new).collect(Collectors.toList()) : Collections.emptyList();
        return new DefaultValidationReport(results);
    }

    private ValidationReport generateValidationReport() {
        ValidationReport validationReport;
        try {
            validationReport = (ValidationReport)this.parser.reportValidation(this.apiVendorToProfileName(this.apiVendor)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Unexpected error parsing API: " + e.getMessage(), e);
        }
        return validationReport;
    }

    private ProfileName apiVendorToProfileName(ApiVendor apiVendor) {
        switch (apiVendor) {
            case OAS: {
                return ProfileNames.OAS();
            }
            case OAS_20: {
                return ProfileNames.OAS20();
            }
            case RAML: {
                return ProfileNames.RAML();
            }
            case RAML_08: {
                return ProfileNames.RAML08();
            }
            case RAML_10: {
                return ProfileNames.RAML10();
            }
        }
        return ProfileNames.AMF();
    }

    public IRaml build() {
        return new AmfImpl(this.webApi, this.references);
    }

    public String dump(String ramlContent, IRaml api, String oldBaseUri, String newBaseUri) {
        return RamlUtils.replaceBaseUri((String)ramlContent, (String)newBaseUri);
    }

    public String dump(IRaml api, String newBaseUri) {
        String dump = this.dumpRaml();
        if (newBaseUri != null) {
            dump = RamlUtils.replaceBaseUri((String)dump, (String)newBaseUri);
        }
        return dump;
    }

    public IRamlUpdater getRamlUpdater(IRaml api) {
        throw new UnsupportedOperationException();
    }

    private String dumpRaml() {
        return this.renderApi();
    }

    public void updateBaseUri(IRaml ignored, String baseUri) {
        if (this.webApi.servers() != null && this.webApi.servers().size() > 0) {
            Server server = (Server)this.webApi.servers().get(0);
            server.withUrl(baseUri);
            server.withVariables(Collections.emptyList());
            this.getConsoleModel().withEncodes((DomainElement)this.webApi);
        }
    }

    public String getAmfModel() {
        try {
            return (String)new AmfGraphRenderer().generateString((BaseUnit)this.getConsoleModel()).get();
        }
        catch (InterruptedException | ExecutionException e) {
            return e.getMessage();
        }
    }

    private String renderApi() {
        Raml08Renderer renderer;
        switch (this.apiVendor) {
            case RAML_08: {
                renderer = new Raml08Renderer();
                break;
            }
            case OAS_20: {
                renderer = new Oas20Renderer();
                break;
            }
            default: {
                renderer = new Raml10Renderer();
            }
        }
        try {
            return (String)renderer.generateString((BaseUnit)this.getConsoleModel()).get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error(String.format("Error render API '%s' to '%s'", this.apiRef.getLocation(), this.apiVendor.name()), (Throwable)e);
            return "";
        }
    }

    private Document getConsoleModel() {
        if (this.consoleModel == null) {
            Document document = this.buildDocument(false);
            this.consoleModel = (Document)CommonUtils.cast((Object)new Raml10Resolver().resolve((BaseUnit)document, "editing"));
        }
        return this.consoleModel;
    }

    private Document buildDocument(boolean validate) {
        URI uri = ParserWrapperAmf.getPathAsUri(this.apiRef);
        return DocumentParser.parseFile(this.parser, uri, validate);
    }
}

