/*
 * Decompiled with CFR 0.152.
 */
package org.mule.amf.impl.model;

import amf.client.model.domain.EndPoint;
import amf.client.model.domain.Server;
import amf.client.model.domain.WebApi;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.amf.impl.model.ParameterImpl;
import org.mule.amf.impl.model.ResourceImpl;
import org.mule.raml.interfaces.model.IRaml;
import org.mule.raml.interfaces.model.IResource;
import org.mule.raml.interfaces.model.ISecurityScheme;
import org.mule.raml.interfaces.model.ITemplate;
import org.mule.raml.interfaces.model.parameter.IParameter;
import scala.Option;

public class AmfImpl
implements IRaml {
    private WebApi webApi;
    private Map<String, Map<String, IResource>> resources = new HashMap<String, Map<String, IResource>>();
    private List<String> references;

    public AmfImpl(WebApi webApi, List<String> references) {
        this.webApi = webApi;
        this.resources = this.buildResources(webApi.endPoints());
        this.references = references;
    }

    private Map<String, Map<String, IResource>> buildResources(List<EndPoint> endPoints) {
        HashMap<String, Map<String, IResource>> resources = new HashMap<String, Map<String, IResource>>();
        endPoints.forEach(endPoint -> this.addToMap((Map<String, Map<String, IResource>>)resources, (EndPoint)endPoint));
        return resources;
    }

    private void addToMap(Map<String, Map<String, IResource>> resources, EndPoint endPoint) {
        String parentKey = AmfImpl.parentKey(endPoint);
        Map parentMap = resources.computeIfAbsent(parentKey, k -> new LinkedHashMap());
        String childKey = endPoint.relativePath();
        parentMap.put(childKey, new ResourceImpl(this, endPoint));
    }

    private static String parentKey(EndPoint endPoint) {
        String path = endPoint.path().value();
        String relativePath = endPoint.relativePath();
        return path.substring(0, path.length() - relativePath.length());
    }

    public IResource getResource(String path) {
        return this.getResources().get(path);
    }

    public Map<String, String> getConsolidatedSchemas() {
        return null;
    }

    public Map<String, Object> getCompiledSchemas() {
        return null;
    }

    public String getBaseUri() {
        return this.getServer().map(server -> server.url().value()).orElse(null);
    }

    private Optional<Server> getServer() {
        return this.webApi.servers().stream().findFirst();
    }

    public Map<String, IResource> getResources() {
        return this.resources.containsKey("") ? this.resources.get("") : Collections.emptyMap();
    }

    Map<String, IResource> getResources(IResource resource) {
        String key = resource.getUri();
        return this.resources.containsKey(key) ? this.resources.get(key) : Collections.emptyMap();
    }

    public String getVersion() {
        return this.webApi.version().value();
    }

    public Map<String, IParameter> getBaseUriParameters() {
        return this.getServer().map(server -> server.variables().stream().collect(Collectors.toMap(p -> p.name().value(), ParameterImpl::new))).orElseGet(Collections::emptyMap);
    }

    public List<Map<String, ISecurityScheme>> getSecuritySchemes() {
        return null;
    }

    public List<Map<String, ITemplate>> getTraits() {
        return null;
    }

    public String getUri() {
        Option location = this.webApi._internal().location();
        return location.isDefined() ? (String)location.get() : null;
    }

    public List<Map<String, String>> getSchemas() {
        return Collections.emptyList();
    }

    public Object getInstance() {
        return null;
    }

    public void cleanBaseUriParameters() {
    }

    public List<String> getAllReferences() {
        return this.references;
    }

    public void injectTrait(String name) {
    }

    public void injectSecurityScheme(Map<String, ISecurityScheme> securityScheme) {
    }
}

