/*
 * Decompiled with CFR 0.152.
 */
package org.mule.amf.impl.parser.rule;

import amf.client.validate.ValidationResult;
import amf.core.parser.Position;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.raml.interfaces.parser.rule.IValidationResult;
import org.mule.raml.interfaces.parser.rule.Severity;

public class ValidationResultImpl
implements IValidationResult {
    private static final String ERROR_FORMAT = "%s\n  Location: %s\n  Position: %s";
    private static final String POSITION_FORMAT = "Line %s,  Column %s";
    private ValidationResult validationResult;
    private List<String> severities;

    public ValidationResultImpl(ValidationResult validationResult) {
        this.validationResult = validationResult;
        this.severities = Arrays.stream(Severity.values()).map(Enum::name).collect(Collectors.toList());
    }

    public String getMessage() {
        return ValidationResultImpl.buildErrorMessage(this.validationResult.message(), this.validationResult.location().orElse(""), this.validationResult.position().start());
    }

    public String getIncludeName() {
        return null;
    }

    public int getLine() {
        return -1;
    }

    public boolean isLineUnknown() {
        return false;
    }

    public String getPath() {
        throw new UnsupportedOperationException();
    }

    public Severity getSeverity() {
        if (!this.severities.contains(this.validationResult.level())) {
            return Severity.ERROR;
        }
        return Severity.fromString((String)this.validationResult.level());
    }

    private static String buildErrorMessage(String message, String location, Position startPosition) {
        return String.format(ERROR_FORMAT, message, URLDecoder.decode(location), ValidationResultImpl.getPositionMessage(startPosition));
    }

    private static String getPositionMessage(Position startPosition) {
        return String.format(POSITION_FORMAT, startPosition.line(), startPosition.column());
    }
}

