/*
 * Decompiled with CFR 0.152.
 */
package org.mule.raml.implv1;

import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.BooleanTypeBuilder;
import org.mule.metadata.api.builder.NumberTypeBuilder;
import org.mule.metadata.api.builder.StringTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.raml.model.parameter.AbstractParam;

public class MetadataResolver {
    private static final MetadataType STRING_METADATA_TYPE = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType().build();

    private MetadataResolver() {
    }

    public static Optional<MetadataType> resolve(AbstractParam param) {
        TypeBuilder builder;
        BaseTypeBuilder rootBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA);
        switch (param.getType()) {
            case NUMBER: {
                builder = MetadataResolver.handle(rootBuilder.numberType(), param);
                break;
            }
            case INTEGER: {
                builder = MetadataResolver.handle(rootBuilder.numberType().integer(), param);
                break;
            }
            case BOOLEAN: {
                builder = MetadataResolver.handle(rootBuilder.booleanType(), param);
                break;
            }
            case STRING: 
            case DATE: 
            case FILE: {
                builder = MetadataResolver.handle(rootBuilder.stringType(), param);
                break;
            }
            default: {
                builder = MetadataResolver.handle(rootBuilder.stringType(), param);
            }
        }
        MetadataType metadataType = param.isRepeat() ? rootBuilder.arrayType().of(builder.build()).build() : builder.build();
        return Optional.of(metadataType);
    }

    private static TypeBuilder handle(BooleanTypeBuilder builder, AbstractParam param) {
        Optional.ofNullable(param.getDefaultValue()).ifPresent(arg_0 -> ((BooleanTypeBuilder)builder).defaultValue(arg_0));
        return builder;
    }

    private static TypeBuilder handle(StringTypeBuilder builder, AbstractParam param) {
        List enumValues = param.getEnumeration();
        if (enumValues != null && !enumValues.isEmpty()) {
            builder.enumOf(enumValues.toArray(new String[enumValues.size()]));
        }
        Optional<Integer> minLength = Optional.ofNullable(param.getMinLength());
        Optional<Integer> maxLength = Optional.ofNullable(param.getMaxLength());
        if (minLength.isPresent() && maxLength.isPresent()) {
            builder.boundary((Number)minLength.get(), (Number)maxLength.get());
        } else {
            maxLength.ifPresent(arg_0 -> ((StringTypeBuilder)builder).length(arg_0));
        }
        Optional.ofNullable(param.getPattern()).ifPresent(arg_0 -> ((StringTypeBuilder)builder).pattern(arg_0));
        Optional.ofNullable(param.getDefaultValue()).ifPresent(arg_0 -> ((StringTypeBuilder)builder).defaultValue(arg_0));
        return builder;
    }

    private static TypeBuilder handle(NumberTypeBuilder builder, AbstractParam param) {
        Optional<BigDecimal> maximum = Optional.ofNullable(param.getMaximum());
        Optional<BigDecimal> minimum = Optional.ofNullable(param.getMinimum());
        if (maximum.isPresent() && minimum.isPresent()) {
            builder.range((Number)minimum.get(), (Number)maximum.get());
        }
        Optional.ofNullable(param.getDefaultValue()).ifPresent(arg_0 -> ((NumberTypeBuilder)builder).defaultValue(arg_0));
        return builder;
    }

    public static MetadataType stringType() {
        return STRING_METADATA_TYPE;
    }
}

