/*
 * Decompiled with CFR 0.152.
 */
package org.mule.raml.implv2.v10.model;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mule.raml.implv2.ParserV2Utils;
import org.mule.raml.implv2.v10.model.ActionImpl;
import org.mule.raml.implv2.v10.model.ParameterImpl;
import org.mule.raml.interfaces.model.IAction;
import org.mule.raml.interfaces.model.IActionType;
import org.mule.raml.interfaces.model.IResource;
import org.mule.raml.interfaces.model.parameter.IParameter;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.methods.Method;
import org.raml.v2.api.model.v10.resources.Resource;

public class ResourceImpl
implements IResource {
    private Resource resource;

    public ResourceImpl(Resource resource) {
        this.resource = resource;
    }

    public String getRelativeUri() {
        return this.resource.relativeUri().value();
    }

    public String getUri() {
        return this.resource.resourcePath();
    }

    public String getParentUri() {
        return this.getUri().substring(0, this.getUri().length() - this.getRelativeUri().length());
    }

    public IAction getAction(String name) {
        for (Method method : this.resource.methods()) {
            if (!method.method().equals(name)) continue;
            return new ActionImpl(method);
        }
        return null;
    }

    public Map<IActionType, IAction> getActions() {
        LinkedHashMap<IActionType, IAction> map = new LinkedHashMap<IActionType, IAction>();
        for (Method method : this.resource.methods()) {
            map.put(IActionType.valueOf((String)method.method().toUpperCase()), new ActionImpl(method));
        }
        return map;
    }

    public Map<String, IResource> getResources() {
        HashMap<String, IResource> result = new HashMap<String, IResource>();
        for (Resource item : this.resource.resources()) {
            result.put(item.relativeUri().value(), new ResourceImpl(item));
        }
        return result;
    }

    public String getDisplayName() {
        return ParserV2Utils.nullSafe(this.resource.displayName());
    }

    public Map<String, IParameter> getResolvedUriParameters() {
        HashMap<String, IParameter> result = new HashMap<String, IParameter>();
        for (Resource current = this.resource; current != null; current = current.parentResource()) {
            for (TypeDeclaration typeDeclaration : current.uriParameters()) {
                result.put(typeDeclaration.name(), new ParameterImpl(typeDeclaration));
            }
        }
        return result;
    }

    public void setParentUri(String parentUri) {
        throw new UnsupportedOperationException();
    }

    public Map<String, List<IParameter>> getBaseUriParameters() {
        throw new UnsupportedOperationException();
    }

    public void cleanBaseUriParameters() {
        throw new UnsupportedOperationException();
    }
}

