/*
 * Decompiled with CFR 0.152.
 */
package org.mule.raml.implv2.v10.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.raml.implv2.ParserV2Utils;
import org.mule.raml.implv2.v10.model.ParameterImpl;
import org.mule.raml.implv2.v10.model.ResourceImpl;
import org.mule.raml.interfaces.model.IRaml;
import org.mule.raml.interfaces.model.IResource;
import org.mule.raml.interfaces.model.ISecurityScheme;
import org.mule.raml.interfaces.model.ITemplate;
import org.mule.raml.interfaces.model.parameter.IParameter;
import org.raml.v2.api.model.v10.api.Api;
import org.raml.v2.api.model.v10.datamodel.AnyTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.ExternalTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.resources.Resource;

public class RamlImpl10V2
implements IRaml {
    private Api api;
    private Optional<String> version;

    public RamlImpl10V2(Api api) {
        this.api = api;
    }

    public Map<String, IResource> getResources() {
        LinkedHashMap<String, IResource> map = new LinkedHashMap<String, IResource>();
        List resources = this.api.resources();
        for (Resource resource : resources) {
            map.put(resource.relativeUri().value(), new ResourceImpl(resource));
        }
        return map;
    }

    public String getBaseUri() {
        return ParserV2Utils.nullSafe(this.api.baseUri());
    }

    public String getVersion() {
        if (this.version == null) {
            this.version = Optional.ofNullable(ParserV2Utils.nullSafe(this.api.version()));
        }
        return this.version.orElse(null);
    }

    public List<Map<String, String>> getSchemas() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        List types = this.api.types();
        if (types.isEmpty()) {
            types = this.api.schemas();
        }
        for (TypeDeclaration typeDeclaration : types) {
            map.put(typeDeclaration.name(), RamlImpl10V2.getTypeAsString(typeDeclaration));
        }
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        result.add(map);
        return result;
    }

    static String getTypeAsString(TypeDeclaration typeDeclaration) {
        if (typeDeclaration instanceof ExternalTypeDeclaration) {
            return ((ExternalTypeDeclaration)typeDeclaration).schemaContent();
        }
        if (typeDeclaration instanceof AnyTypeDeclaration) {
            return null;
        }
        return typeDeclaration.toJsonSchema();
    }

    public IResource getResource(String path) {
        throw new UnsupportedOperationException();
    }

    public Map<String, String> getConsolidatedSchemas() {
        return Collections.emptyMap();
    }

    public Map<String, Object> getCompiledSchemas() {
        throw new UnsupportedOperationException();
    }

    public Map<String, IParameter> getBaseUriParameters() {
        LinkedHashMap<String, IParameter> baseUriParameters = new LinkedHashMap<String, IParameter>();
        this.api.baseUriParameters().forEach(type -> {
            IParameter cfr_ignored_0 = baseUriParameters.put(type.name(), new ParameterImpl((TypeDeclaration)type));
        });
        return baseUriParameters;
    }

    public List<Map<String, ISecurityScheme>> getSecuritySchemes() {
        throw new UnsupportedOperationException();
    }

    public List<Map<String, ITemplate>> getTraits() {
        throw new UnsupportedOperationException();
    }

    public String getUri() {
        throw new UnsupportedOperationException();
    }

    public Object getInstance() {
        throw new UnsupportedOperationException();
    }

    public void cleanBaseUriParameters() {
        throw new UnsupportedOperationException();
    }

    public void injectTrait(String name) {
        throw new UnsupportedOperationException();
    }

    public void injectSecurityScheme(Map<String, ISecurityScheme> securityScheme) {
        throw new UnsupportedOperationException();
    }
}

