/*
 * Decompiled with CFR 0.152.
 */
package org.mule.raml.implv2;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import org.mule.raml.implv2.ParserV2Utils;
import org.mule.raml.implv2.loader.ExchangeDependencyResourceLoader;
import org.mule.raml.interfaces.ParserWrapper;
import org.mule.raml.interfaces.common.RamlUtils;
import org.mule.raml.interfaces.injector.IRamlUpdater;
import org.mule.raml.interfaces.model.ApiVendor;
import org.mule.raml.interfaces.model.IRaml;
import org.mule.raml.interfaces.parser.rule.DefaultValidationReport;
import org.mule.raml.interfaces.parser.rule.IValidationReport;
import org.mule.raml.interfaces.parser.rule.IValidationResult;
import org.raml.v2.api.loader.CompositeResourceLoader;
import org.raml.v2.api.loader.DefaultResourceLoader;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.api.loader.RootRamlFileResourceLoader;
import org.raml.v2.internal.utils.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParserWrapperV2
implements ParserWrapper {
    private static final Logger logger = LoggerFactory.getLogger(ParserWrapperV2.class);
    private final String ramlPath;
    private final ResourceLoader resourceLoader;

    public ParserWrapperV2(String ramlPath) {
        this(ramlPath, ParserWrapperV2.buildResourceLoader(ramlPath));
    }

    public ParserWrapperV2(String ramlPath, ResourceLoader resourceLoader) {
        this.ramlPath = ramlPath;
        this.resourceLoader = resourceLoader;
    }

    private static ResourceLoader buildResourceLoader(String ramlPath) {
        File ramlFile = ParserWrapperV2.fetchRamlFile(ramlPath);
        if (ramlFile != null && ramlFile.getParent() != null) {
            return new CompositeResourceLoader(new ResourceLoader[]{new RootRamlFileResourceLoader(ramlFile.getParentFile()), new DefaultResourceLoader(), new ExchangeDependencyResourceLoader(ramlFile.getParentFile().getAbsolutePath())});
        }
        return new DefaultResourceLoader();
    }

    private static File fetchRamlFile(String ramlPath) {
        return Optional.ofNullable(ramlPath).map(p -> Thread.currentThread().getContextClassLoader().getResource((String)p)).filter(ParserWrapperV2::isFile).map(resource -> new File(resource.getFile())).orElse(null);
    }

    private static boolean isFile(URL url) {
        return "file".equals(url.getProtocol());
    }

    public ApiVendor getApiVendor() {
        return ApiVendor.RAML_10;
    }

    public void validate() {
        List<IValidationResult> errors = ParserV2Utils.validate(this.resourceLoader, this.ramlPath);
        if (!errors.isEmpty()) {
            StringBuilder message = new StringBuilder("Invalid API descriptor -- errors found: ");
            message.append(errors.size()).append("\n\n");
            for (IValidationResult error : errors) {
                message.append(error.getMessage()).append("\n");
            }
            throw new RuntimeException(message.toString());
        }
    }

    public IValidationReport validationReport() {
        List<IValidationResult> results = ParserV2Utils.validate(this.resourceLoader, this.ramlPath);
        return new DefaultValidationReport(results);
    }

    public IRaml build() {
        return ParserV2Utils.build(this.resourceLoader, this.ramlPath);
    }

    public String dump(String ramlContent, IRaml api, String oldSchemeHostPort, String newSchemeHostPort) {
        return RamlUtils.replaceBaseUri((String)ramlContent, (String)newSchemeHostPort);
    }

    public String dump(IRaml api, String newBaseUri) {
        String dump = this.dumpRaml(api);
        if (newBaseUri != null) {
            dump = RamlUtils.replaceBaseUri((String)dump, (String)newBaseUri);
        }
        return dump;
    }

    private String dumpRaml(IRaml api) {
        InputStream stream = this.resourceLoader.fetchResource(this.ramlPath);
        if (stream == null) {
            throw new RuntimeException("Invalid RAML descriptor");
        }
        return StreamUtils.toString((InputStream)stream);
    }

    public IRamlUpdater getRamlUpdater(IRaml api) {
        throw new UnsupportedOperationException("RAML 1.0 is read only");
    }

    public void updateBaseUri(IRaml api, String baseUri) {
        logger.debug("RAML 1.0 parser does not support base uri updates");
    }
}

