/*
 * Decompiled with CFR 0.152.
 */
package org.mule.raml.implv2.v10.model;

import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mule.metadata.api.model.MetadataType;
import org.mule.raml.implv2.v10.MetadataResolver;
import org.mule.raml.interfaces.model.parameter.IParameter;
import org.raml.v2.api.model.common.ValidationResult;
import org.raml.v2.api.model.v10.datamodel.ArrayTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.ExampleSpec;
import org.raml.v2.api.model.v10.datamodel.ObjectTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.system.types.AnnotableStringType;
import org.raml.v2.api.model.v10.system.types.MarkdownString;
import org.raml.v2.internal.impl.v10.type.TypeId;

public class ParameterImpl
implements IParameter {
    private TypeDeclaration typeDeclaration;
    private Collection<String> scalarTypes;

    public ParameterImpl(TypeDeclaration typeDeclaration) {
        this.typeDeclaration = typeDeclaration;
        HashSet typeIds = Sets.newHashSet((Object[])TypeId.values());
        typeIds.remove(TypeId.OBJECT);
        typeIds.remove(TypeId.ARRAY);
        this.scalarTypes = Collections2.transform((Collection)typeIds, TypeId::getType);
    }

    public boolean validate(String value) {
        List results = this.typeDeclaration.validate(value);
        return results.isEmpty();
    }

    public String message(String value) {
        List results = this.typeDeclaration.validate(value);
        return results.isEmpty() ? "OK" : ((ValidationResult)results.get(0)).getMessage();
    }

    public boolean isRequired() {
        return this.typeDeclaration.required();
    }

    public String getDefaultValue() {
        return this.typeDeclaration.defaultValue();
    }

    public boolean isRepeat() {
        return false;
    }

    public boolean isArray() {
        return this.typeDeclaration instanceof ArrayTypeDeclaration;
    }

    public String getDisplayName() {
        AnnotableStringType type = this.typeDeclaration.displayName();
        return type == null ? null : type.value();
    }

    public String getDescription() {
        MarkdownString description = this.typeDeclaration.description();
        return description == null ? null : description.value();
    }

    public String getExample() {
        if (this.typeDeclaration.example() == null) {
            return null;
        }
        return this.typeDeclaration.example().value();
    }

    public Map<String, String> getExamples() {
        LinkedHashMap<String, String> examples = new LinkedHashMap<String, String>();
        for (ExampleSpec example : this.typeDeclaration.examples()) {
            examples.put(example.name(), example.value());
        }
        return examples;
    }

    public Object getInstance() {
        throw new UnsupportedOperationException();
    }

    public MetadataType getMetadata() {
        return MetadataResolver.resolve(this.typeDeclaration).orElse(MetadataResolver.anyType());
    }

    public boolean isScalar() {
        return this.scalarTypes.contains(this.typeDeclaration.type());
    }

    public boolean isFacetArray(String facet) {
        if (this.typeDeclaration instanceof ObjectTypeDeclaration) {
            for (TypeDeclaration type : ((ObjectTypeDeclaration)this.typeDeclaration).properties()) {
                if (!type.name().equals(facet)) continue;
                return type instanceof ArrayTypeDeclaration;
            }
        }
        return false;
    }
}

