/*
 * Decompiled with CFR 0.152.
 */
package org.mule.raml.implv2.v08.model;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.mule.raml.implv2.v08.model.MimeTypeImpl;
import org.mule.raml.implv2.v08.model.ParameterImpl;
import org.mule.raml.interfaces.model.IMimeType;
import org.mule.raml.interfaces.model.IResponse;
import org.mule.raml.interfaces.model.parameter.IParameter;
import org.raml.v2.api.model.v08.bodies.BodyLike;
import org.raml.v2.api.model.v08.bodies.Response;
import org.raml.v2.api.model.v08.parameters.Parameter;

public class ResponseImpl
implements IResponse {
    private Response response;
    private Map<String, IMimeType> body;

    public ResponseImpl(Response response) {
        this.response = response;
    }

    public boolean hasBody() {
        return !this.response.body().isEmpty();
    }

    public Map<String, IMimeType> getBody() {
        if (this.body == null) {
            this.body = ResponseImpl.loadBody(this.response);
        }
        return this.body;
    }

    private static Map<String, IMimeType> loadBody(Response response) {
        LinkedHashMap<String, IMimeType> result = new LinkedHashMap<String, IMimeType>();
        for (BodyLike bodyLike : response.body()) {
            result.put(bodyLike.name(), new MimeTypeImpl(bodyLike));
        }
        return result;
    }

    public Map<String, IParameter> getHeaders() {
        LinkedHashMap<String, IParameter> result = new LinkedHashMap<String, IParameter>();
        Optional.ofNullable(this.response.headers()).ifPresent(headers -> headers.forEach(header -> {
            IParameter cfr_ignored_0 = result.put(header.name(), new ParameterImpl((Parameter)header));
        }));
        return result;
    }

    public void setBody(Map<String, IMimeType> body) {
        throw new UnsupportedOperationException();
    }

    public void setHeaders(Map<String, IParameter> headers) {
        throw new UnsupportedOperationException();
    }

    public Object getInstance() {
        throw new UnsupportedOperationException();
    }
}

