/*
 * Decompiled with CFR 0.152.
 */
package org.mule.raml.implv2;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.mule.raml.implv2.parser.rule.ValidationResultImpl;
import org.mule.raml.implv2.v08.model.RamlImpl08V2;
import org.mule.raml.implv2.v10.model.RamlImpl10V2;
import org.mule.raml.interfaces.model.IRaml;
import org.mule.raml.interfaces.parser.rule.IValidationResult;
import org.raml.v2.api.RamlModelBuilder;
import org.raml.v2.api.RamlModelResult;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.api.model.common.ValidationResult;
import org.raml.v2.api.model.v10.system.types.AnnotableSimpleType;
import org.raml.v2.internal.impl.commons.nodes.LibraryNodeProvider;
import org.raml.v2.internal.impl.v10.nodes.LibraryLinkNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.snakeyaml.SYIncludeNode;

public class ParserV2Utils {
    public static final String PARSER_V2_PROPERTY = "apikit.raml.parser.v2";
    private static final String RAML_PATH_SEPARATOR = "/";

    public static IRaml build(ResourceLoader resourceLoader, String ramlPath) {
        RamlModelResult ramlModelResult = new RamlModelBuilder(resourceLoader).buildApi(ramlPath);
        return ParserV2Utils.wrapApiModel(ramlModelResult, resourceLoader, ramlPath);
    }

    public static IRaml build(ResourceLoader resourceLoader, String ramlPath, String content) {
        RamlModelResult ramlModelResult = new RamlModelBuilder(resourceLoader).buildApi(content, ramlPath);
        return ParserV2Utils.wrapApiModel(ramlModelResult, resourceLoader, ramlPath);
    }

    private static IRaml wrapApiModel(RamlModelResult ramlModelResult, ResourceLoader resourceLoader, String ramlPath) {
        if (ramlModelResult.hasErrors()) {
            throw new RuntimeException("Invalid RAML descriptor.");
        }
        if (ramlModelResult.isVersion08()) {
            return new RamlImpl08V2(ramlModelResult.getApiV08());
        }
        return new RamlImpl10V2(ramlModelResult.getApiV10(), resourceLoader, ramlPath);
    }

    public static List<IValidationResult> validate(ResourceLoader resourceLoader, String ramlPath, String content) {
        ArrayList<IValidationResult> result = new ArrayList<IValidationResult>();
        try {
            RamlModelResult ramlApiResult = new RamlModelBuilder(resourceLoader).buildApi(content, ramlPath);
            for (ValidationResult validationResult : ramlApiResult.getValidationResults()) {
                result.add(new ValidationResultImpl(validationResult));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Raml parser uncaught exception: " + e.getMessage());
        }
        return result;
    }

    public static List<IValidationResult> validate(ResourceLoader resourceLoader, String ramlPath) {
        return ParserV2Utils.validate(resourceLoader, ramlPath, null);
    }

    public static boolean useParserV2(String content) {
        String property = System.getProperty(PARSER_V2_PROPERTY);
        if (property != null && Boolean.valueOf(property).booleanValue()) {
            return true;
        }
        return content.startsWith("#%RAML 1.0");
    }

    public static String nullSafe(AnnotableSimpleType<?> simpleType) {
        return simpleType != null ? String.valueOf(simpleType.value()) : null;
    }

    public static List<String> findIncludeNodes(Node raml, String ramlPath) {
        ArrayList<String> includePaths = new ArrayList<String>();
        ParserV2Utils.findIncludeNodes("", includePaths, Arrays.asList(raml), ramlPath);
        return includePaths;
    }

    private static void findIncludeNodes(String pathRelativeToRoot, List<String> includePaths, List<Node> currents, String ramlPath) {
        String rootPath = new File(ramlPath).getParent();
        Iterator<Node> iterator = currents.iterator();
        while (iterator.hasNext()) {
            Node current;
            String pathRelativeToRootCurrent = pathRelativeToRoot;
            for (Node possibleInclude = current = iterator.next(); possibleInclude != null; possibleInclude = possibleInclude.getSource()) {
                String includePath = null;
                if (possibleInclude instanceof SYIncludeNode) {
                    includePath = ((SYIncludeNode)possibleInclude).getIncludePath();
                } else if (possibleInclude instanceof LibraryLinkNode) {
                    includePath = ((LibraryLinkNode)possibleInclude).getRefName();
                }
                if (includePath == null) continue;
                includePaths.add(ParserV2Utils.computeIncludePath(rootPath, pathRelativeToRoot, includePath));
                pathRelativeToRootCurrent = ParserV2Utils.calculateNextRootRelative(pathRelativeToRootCurrent, includePath);
            }
            ParserV2Utils.findIncludeNodes(pathRelativeToRootCurrent, includePaths, ParserV2Utils.getChildren(current), ramlPath);
        }
    }

    private static String calculateNextRootRelative(String pathRelativeToRootCurrent, String includePath) {
        String newRelativeSubPath = new File(includePath).getParent();
        newRelativeSubPath = newRelativeSubPath == null ? "" : newRelativeSubPath;
        return pathRelativeToRootCurrent + newRelativeSubPath;
    }

    private static List<Node> getChildren(Node node) {
        if (node instanceof LibraryLinkNode) {
            node = ((LibraryLinkNode)node).getRefNode();
        }
        ArrayList<Node> result = new ArrayList<Node>();
        if (node != null) {
            LibraryNodeProvider libraryNodeProvider;
            Node libraryNode;
            if (node instanceof LibraryNodeProvider && (libraryNode = (libraryNodeProvider = (LibraryNodeProvider)node).getLibraryNode()) != null) {
                result.add(libraryNode);
            }
            result.addAll(node.getChildren());
        }
        return result;
    }

    private static String computeIncludePath(String rootPath, String pathRelativeToRoot, String includePath) {
        String resolvedPath = ParserV2Utils.isAbsolute(includePath) ? rootPath + includePath : rootPath + (pathRelativeToRoot.isEmpty() ? "" : File.separator + pathRelativeToRoot) + File.separator + includePath;
        return new File(resolvedPath).toURI().toString();
    }

    private static boolean isAbsolute(String includePath) {
        return includePath.startsWith(RAML_PATH_SEPARATOR);
    }
}

