/*
 * Decompiled with CFR 0.152.
 */
package org.mule.raml.implv2.v08.model;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mule.raml.implv2.v08.model.ActionImpl;
import org.mule.raml.implv2.v08.model.ParameterImpl;
import org.mule.raml.interfaces.ParserUtils;
import org.mule.raml.interfaces.model.IAction;
import org.mule.raml.interfaces.model.IActionType;
import org.mule.raml.interfaces.model.IResource;
import org.mule.raml.interfaces.model.parameter.IParameter;
import org.raml.v2.api.model.v08.methods.Method;
import org.raml.v2.api.model.v08.parameters.Parameter;
import org.raml.v2.api.model.v08.resources.Resource;

public class ResourceImpl
implements IResource {
    private Resource resource;
    private Map<IActionType, IAction> actions;
    private Map<String, IParameter> resolvedUriParameters;

    public ResourceImpl(Resource resource) {
        this.resource = resource;
    }

    public String getRelativeUri() {
        return this.resource.relativeUri().value();
    }

    public String getUri() {
        return this.resource.resourcePath();
    }

    public String getResolvedUri(String version) {
        return ParserUtils.resolveVersion((String)this.getUri(), (String)version);
    }

    public String getParentUri() {
        return this.getUri().substring(0, this.getUri().length() - this.getRelativeUri().length());
    }

    public IAction getAction(String name) {
        return this.getActions().get(ResourceImpl.getActionKey(name));
    }

    public Map<IActionType, IAction> getActions() {
        if (this.actions == null) {
            this.actions = ResourceImpl.loadActions(this.resource);
        }
        return this.actions;
    }

    private static Map<IActionType, IAction> loadActions(Resource resource) {
        LinkedHashMap<IActionType, IAction> map = new LinkedHashMap<IActionType, IAction>();
        for (Method method : resource.methods()) {
            map.put(ResourceImpl.getActionKey(method.method()), new ActionImpl(method));
        }
        return map;
    }

    private static IActionType getActionKey(String method) {
        return IActionType.valueOf((String)method.toUpperCase());
    }

    public Map<String, IResource> getResources() {
        HashMap<String, IResource> result = new HashMap<String, IResource>();
        for (Resource item : this.resource.resources()) {
            result.put(item.relativeUri().value(), new ResourceImpl(item));
        }
        return result;
    }

    public String getDisplayName() {
        return this.resource.displayName();
    }

    public Map<String, IParameter> getResolvedUriParameters() {
        if (this.resolvedUriParameters == null) {
            this.resolvedUriParameters = ResourceImpl.loadResolvedUriParameters(this.resource);
        }
        return this.resolvedUriParameters;
    }

    static Map<String, IParameter> loadResolvedUriParameters(Resource resource) {
        HashMap<String, IParameter> result = new HashMap<String, IParameter>();
        for (Resource current = resource; current != null; current = current.parentResource()) {
            for (Parameter parameter : current.uriParameters()) {
                result.put(parameter.name(), new ParameterImpl(parameter));
            }
        }
        return result;
    }

    public void setParentUri(String parentUri) {
        throw new UnsupportedOperationException();
    }

    public Map<String, List<IParameter>> getBaseUriParameters() {
        throw new UnsupportedOperationException();
    }

    public void cleanBaseUriParameters() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.getUri();
    }
}

