/*
 * Decompiled with CFR 0.152.
 */
package org.mule.raml.interfaces;

import java.util.Iterator;
import java.util.ServiceLoader;
import org.mule.raml.interfaces.IRamlFactory;
import org.mule.raml.interfaces.emitter.IRamlEmitter;
import org.mule.raml.interfaces.parser.visitor.IRamlCloningService;
import org.mule.raml.interfaces.parser.visitor.IRamlDocumentBuilder;
import org.mule.raml.interfaces.parser.visitor.IRamlValidationService;

public class RamlFactoryHelper {
    private static IRamlFactory iRamlFactory;

    private static IRamlFactory loadFactory() {
        if (iRamlFactory != null) {
            return iRamlFactory;
        }
        ServiceLoader<IRamlFactory> loader = ServiceLoader.load(IRamlFactory.class);
        Iterator<IRamlFactory> it = loader.iterator();
        if (it.hasNext()) {
            iRamlFactory = it.next();
            return iRamlFactory;
        }
        throw new RuntimeException("RamlFactoryLoader couldn't find any RamlFactory");
    }

    public static IRamlEmitter createRamlEmitter() {
        return RamlFactoryHelper.loadFactory().createRamlEmitter();
    }

    public static IRamlDocumentBuilder createRamlDocumentBuilder() {
        return RamlFactoryHelper.loadFactory().createRamlDocumentBuilder();
    }

    public static IRamlValidationService createRamlValidationService(IRamlDocumentBuilder ramlDocumentBuilder) {
        return RamlFactoryHelper.loadFactory().createRamlValidationService(ramlDocumentBuilder);
    }

    public static IRamlCloningService createRamlCloningService() {
        return RamlFactoryHelper.loadFactory().createRamlCloningService();
    }
}

