/*
 * Decompiled with CFR 0.152.
 */
package org.mule.raml.interfaces.loader;

import java.net.URI;
import org.mule.raml.interfaces.common.APISyncUtils;
import org.mule.raml.interfaces.loader.ClassPathResourceLoader;
import org.mule.raml.interfaces.loader.ResourceLoader;

public class ApiSyncResourceLoader
implements ResourceLoader {
    private ResourceLoader resourceLoader;
    private String rootRamlResource;

    public ApiSyncResourceLoader(String resource) {
        this(resource, new ClassPathResourceLoader());
    }

    public ApiSyncResourceLoader(String resource, ResourceLoader resourceLoader) {
        this.rootRamlResource = this.getRootRamlResource(resource);
        this.resourceLoader = resourceLoader;
    }

    @Override
    public URI getResource(String path) {
        String resourcePath = path.startsWith("/") ? path.substring(1) : path;
        if (APISyncUtils.isExchangeModules(resourcePath)) {
            return this.resourceLoader.getResource(APISyncUtils.toApiSyncResource(resourcePath));
        }
        if (APISyncUtils.isSyncProtocol(path)) {
            return this.resourceLoader.getResource(resourcePath);
        }
        return this.resourceLoader.getResource(this.rootRamlResource + resourcePath);
    }

    private String getRootRamlResource(String rootRamlResource) {
        return rootRamlResource.substring(0, rootRamlResource.lastIndexOf(":") + 1);
    }
}

