/*
 * Decompiled with CFR 0.152.
 */
package org.mule.raml.interfaces.common;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class APISyncUtils {
    public static final String EXCHANGE_JSON = "exchange.json";
    public static final String API_SYNC_PROTOCOL = "resource::";
    public static final String RESOURCE_FORMAT = "resource::%s:%s:%s:%s:%s:%s";
    public static final String RAML_FRAGMENT_CLASSIFIER = "raml-fragment";
    public static final String EXCHANGE_TYPE = "zip";
    public static final String EXCHANGE_MODULES = "exchange_modules";
    static final String EXCHANGE_ROOT_RAML_TAG = "\"main\":\"";
    public static final String EXCHANGE_MODULE_REGEX = "exchange_modules/([^/]+)/([^/]+)/([^/]+)/(.*)";
    private static final Pattern EXCHANGE_PATTERN = Pattern.compile("exchange_modules/([^/]+)/([^/]+)/([^/]+)/(.*)");

    private APISyncUtils() {
    }

    public static boolean isSyncProtocol(String path) {
        return path.startsWith(API_SYNC_PROTOCOL);
    }

    public static String getFileName(String apiSyncResource) {
        return apiSyncResource.substring(apiSyncResource.lastIndexOf(":") + 1);
    }

    public static boolean isExchangeModules(String path) {
        return path.startsWith(EXCHANGE_MODULES) || path.startsWith("/exchange_modules");
    }

    public static String getMainApi(String exchangeJson) {
        exchangeJson = exchangeJson.substring(exchangeJson.indexOf(EXCHANGE_ROOT_RAML_TAG) + EXCHANGE_ROOT_RAML_TAG.length());
        exchangeJson = exchangeJson.substring(0, exchangeJson.indexOf("\""));
        return exchangeJson;
    }

    public static String toApiSyncResource(String s) {
        String apiSyncResource = null;
        Matcher exchangeMatcher = EXCHANGE_PATTERN.matcher(s);
        if (exchangeMatcher.matches()) {
            String groupId = exchangeMatcher.group(1);
            String artifactId = exchangeMatcher.group(2);
            String version = exchangeMatcher.group(3);
            String filePath = exchangeMatcher.group(4);
            apiSyncResource = String.format(RESOURCE_FORMAT, groupId, artifactId, version, RAML_FRAGMENT_CLASSIFIER, EXCHANGE_TYPE, filePath);
        }
        return apiSyncResource;
    }

    public static boolean compareResourcesLocation(String resourceA, String resourceB, Boolean checkVersion) {
        APISyncResource apiSyncResourceA = null;
        APISyncResource apiSyncResourceB = null;
        try {
            apiSyncResourceA = new APISyncResource(resourceA);
            apiSyncResourceB = new APISyncResource(resourceB);
        }
        catch (APISyncResourceException e) {
            return false;
        }
        return apiSyncResourceA.equals(apiSyncResourceB, checkVersion);
    }

    private static class APISyncResourceException
    extends Exception {
        public APISyncResourceException(String message) {
            super(message);
        }
    }

    private static class APISyncResource {
        private String groupId;
        private String artifact;
        private String version;
        private String classifier;
        private String packager;
        private String file;

        APISyncResource(String resource) throws APISyncResourceException {
            if (!APISyncUtils.isSyncProtocol(resource)) {
                throw new APISyncResourceException("Invalid APISync Resource");
            }
            String[] parts = resource.substring(APISyncUtils.API_SYNC_PROTOCOL.length()).split(":");
            if (parts.length != 6) {
                throw new APISyncResourceException("Invalid APISync Resource");
            }
            this.groupId = parts[0];
            this.artifact = parts[1];
            this.version = parts[2];
            this.classifier = parts[3];
            this.packager = parts[4];
            this.file = parts[5];
        }

        public boolean equals(APISyncResource resource, Boolean checkVersion) {
            return this.groupId.equals(resource.groupId) && this.artifact.equals(resource.artifact) && (checkVersion == false || this.version.equals(resource.version)) && this.classifier.equals(resource.classifier) && this.packager.equals(resource.packager) && this.file.equals(resource.file);
        }
    }
}

