/*
 * Decompiled with CFR 0.152.
 */
package org.mule.raml.interfaces.model.api;

import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import org.mule.raml.interfaces.common.APISyncUtils;
import org.mule.raml.interfaces.common.ApiVendorUtils;
import org.mule.raml.interfaces.loader.ResourceLoader;
import org.mule.raml.interfaces.model.ApiVendor;
import org.mule.raml.interfaces.model.api.ApiSyncApiRef;
import org.mule.raml.interfaces.model.api.DefaultApiRef;
import org.mule.raml.interfaces.model.api.URIApiRef;

public interface ApiRef {
    public static ApiRef create(String location, ResourceLoader resourceLoader) {
        if (APISyncUtils.isSyncProtocol(location)) {
            return resourceLoader != null ? new ApiSyncApiRef(location, resourceLoader) : new ApiSyncApiRef(location);
        }
        try {
            URI uri = new URI(location);
            if (uri.isAbsolute()) {
                return new URIApiRef(uri, resourceLoader);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return new DefaultApiRef(location, resourceLoader);
    }

    public static ApiRef create(String location) {
        return ApiRef.create(location, null);
    }

    public static ApiRef create(URI uri) {
        return new URIApiRef(uri);
    }

    public String getLocation();

    public String getFormat();

    public InputStream resolve();

    default public ApiVendor getVendor() {
        String format = this.getFormat();
        if ("RAML".equalsIgnoreCase(format)) {
            ApiVendor ramlVendor = ApiVendorUtils.getRamlVendor(this.resolve());
            return ramlVendor != null ? ramlVendor : ApiVendor.RAML_10;
        }
        if ("JSON".equalsIgnoreCase(format)) {
            return ApiVendor.OAS_20;
        }
        return ApiVendorUtils.deduceApiVendor(this.resolve());
    }

    public Optional<ResourceLoader> getResourceLoader();
}

