/*
 * Decompiled with CFR 0.152.
 */
package org.mule.raml.interfaces.model.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.mule.raml.interfaces.loader.ResourceLoader;
import org.mule.raml.interfaces.model.api.ApiRef;

class DefaultApiRef
implements ApiRef {
    private String location;
    private Optional<ResourceLoader> resourceLoader;

    DefaultApiRef(String location) {
        this(location, null);
    }

    DefaultApiRef(String location, ResourceLoader resourceLoader) {
        this.location = location;
        this.resourceLoader = Optional.ofNullable(resourceLoader);
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public String getFormat() {
        return FilenameUtils.getExtension((String)this.location).toUpperCase();
    }

    @Override
    public InputStream resolve() {
        if (this.resourceLoader.isPresent()) {
            return this.resourceLoader.map(loader -> loader.getResourceAsStream(this.location)).orElse(null);
        }
        File file = new File(this.location);
        if (file.exists()) {
            try {
                return new FileInputStream(file);
            }
            catch (Exception e) {
                return null;
            }
        }
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(this.location);
    }

    @Override
    public Optional<ResourceLoader> getResourceLoader() {
        return this.resourceLoader;
    }
}

