/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.api.meta.model.declaration.fluent;

import org.mule.runtime.api.meta.model.ModelProperty;

/**
 * A contract interface for a declarer capable of adding a model properties
 *
 * @param <T> the type of the implementing type. Used to allow method chaining
 * @since 1.0
 */
public interface HasModelProperties<T> {

  /**
   * Adds the given {@code modelProperty}
   *
   * @param modelProperty a {@link ModelProperty}
   * @return {@code this} declarer
   * @throws IllegalArgumentException if {@code modelProperty} is {@code null{}}
   */
  T withModelProperty(ModelProperty modelProperty);

}
