/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.metadata;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Optional;
import org.mule.runtime.api.metadata.DataType;

public final class TypedValue<T>
implements Serializable {
    private static final long serialVersionUID = -2533879516750283994L;
    private final T value;
    private final DataType dataType;
    private final long length;

    public static <T> T unwrap(Object value) {
        if (value instanceof TypedValue) {
            return ((TypedValue)value).getValue();
        }
        return (T)value;
    }

    public static <T> TypedValue<T> of(T value) {
        if (value instanceof TypedValue) {
            return (TypedValue)value;
        }
        return new TypedValue<T>(value, DataType.fromObject(value));
    }

    public TypedValue(T value, DataType dataType) {
        this(value, dataType, Optional.empty());
    }

    public TypedValue(T value, DataType dataType, Optional<Long> length) {
        this.value = value;
        this.dataType = dataType == null ? DataType.fromObject(value) : dataType;
        this.length = length.isPresent() ? length.get() : (value instanceof byte[] ? (long)((byte[])value).length : (value instanceof String ? (long)((String)value).getBytes(this.dataType.getMediaType().getCharset().orElse(Charset.defaultCharset())).length : -1L));
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public T getValue() {
        return this.value;
    }

    public Optional<Long> getLength() {
        return this.length >= 0L ? Optional.of(this.length) : Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypedValue that = (TypedValue)o;
        if (this.length != that.length) {
            return false;
        }
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        return this.dataType.equals(that.dataType);
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + this.dataType.hashCode();
        result = 31 * result + (int)(this.length ^ this.length >>> 32);
        return result;
    }
}

