/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.notification;

import org.mule.runtime.api.notification.EnrichedNotificationInfo;
import org.mule.runtime.api.notification.EnrichedServerNotification;

public class TransactionNotification
extends EnrichedServerNotification {
    private static final long serialVersionUID = -3245036187011582121L;
    private static String UNKNOWN_APPLICATION_NAME = "unknown";
    public static final int TRANSACTION_BEGAN = 1201;
    public static final int TRANSACTION_COMMITTED = 1202;
    public static final int TRANSACTION_ROLLEDBACK = 1203;
    private String applicationName;
    private String transactionStringId;

    public TransactionNotification(String id, int action) {
        this(id, action, UNKNOWN_APPLICATION_NAME);
    }

    public TransactionNotification(String id, int action, String applicationName) {
        super(TransactionNotification.emptyInfo(), action, id);
        this.transactionStringId = id;
        this.applicationName = applicationName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getTransactionStringId() {
        return this.transactionStringId;
    }

    @Override
    public String toString() {
        return this.EVENT_NAME + "{action=" + TransactionNotification.getActionName(this.action) + ", transactionStringId=" + this.transactionStringId + ", timestamp=" + this.timestamp + "}";
    }

    private static EnrichedNotificationInfo emptyInfo() {
        return new EnrichedNotificationInfo(null, null, null);
    }

    @Override
    public boolean isSynchronous() {
        return true;
    }

    static {
        TransactionNotification.registerAction("begin", 1201);
        TransactionNotification.registerAction("commit", 1202);
        TransactionNotification.registerAction("rollback", 1203);
    }
}

