/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.api.meta.model.stereotype;

import java.util.Optional;

/**
 * A model which represents an stereotype qualifier for the {@link StereotypedModel} that is categorized with this stereotype.
 * An stereotype is a widely held but fixed and oversimplified image or idea of the owning model.
 * Examples would be {@code validator}, {@code source}, {@code processor}, etc.
 *
 * @since 1.0
 */
public interface StereotypeModel {

  /**
   * Gets the name of the stereotype.
   * @return The type of the error
   */
  String getName();

  /**
   * Gets the namespace of error.
   * This namespace represent the origin or who declares this error, so it could be the namespace of an
   * extension or the {@code MULE} namespace.
   *
   * @return The namespace of the error
   */
  String getNamespace();

  /**
   * @return The {@link StereotypeModel} parent of the current {@link StereotypeModel} from which it inherits from.
   */
  Optional<StereotypeModel> getParent();
}
