/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.meta.model;

import java.util.Optional;
import org.mule.runtime.api.meta.DescribedObject;
import org.mule.runtime.api.meta.ExternalLibraryType;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.util.Preconditions;

public final class ExternalLibraryModel
implements NamedObject,
DescribedObject {
    private String name;
    private String description;
    private String regexMatcher;
    private String requiredClassName;
    private ExternalLibraryType type;

    public static ExternalLibraryModelBuilder builder() {
        return new ExternalLibraryModelBuilder();
    }

    private ExternalLibraryModel() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public Optional<String> getRegexMatcher() {
        return Optional.ofNullable(this.regexMatcher);
    }

    public Optional<String> getRequiredClassName() {
        return Optional.ofNullable(this.requiredClassName);
    }

    public ExternalLibraryType getType() {
        return this.type;
    }

    public static class ExternalLibraryModelBuilder {
        private final ExternalLibraryModel product = new ExternalLibraryModel();

        private ExternalLibraryModelBuilder() {
        }

        public ExternalLibraryModelBuilder withName(String name) {
            Preconditions.checkArgument(name != null && !name.trim().isEmpty(), "name cannot be blank");
            this.product.name = name;
            return this;
        }

        public ExternalLibraryModelBuilder withDescription(String description) {
            this.product.description = description;
            return this;
        }

        public ExternalLibraryModelBuilder withRegexpMatcher(String regexMatcher) {
            this.product.regexMatcher = regexMatcher;
            return this;
        }

        public ExternalLibraryModelBuilder withRequiredClassName(String requiredClassName) {
            this.product.requiredClassName = requiredClassName;
            return this;
        }

        public ExternalLibraryModelBuilder withType(ExternalLibraryType type) {
            this.product.type = type;
            return this;
        }

        public ExternalLibraryModel build() {
            Preconditions.checkState(this.product.name != null, "name was not provided");
            return this.product;
        }
    }
}

