/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.meta.model.util;

import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.connection.HasConnectionProviderModels;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.construct.HasConstructModels;
import org.mule.runtime.api.meta.model.function.FunctionModel;
import org.mule.runtime.api.meta.model.function.HasFunctionModels;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.HasSourceModels;
import org.mule.runtime.api.meta.model.source.SourceCallbackModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.api.util.ExtensionModelTestUtils;

@RunWith(value=MockitoJUnitRunner.class)
public class ExtensionWalkerTestCase {
    @Mock
    private ExtensionModel extension;
    @Mock
    private ConfigurationModel configuration;
    @Mock
    private OperationModel operation;
    @Mock
    private ConstructModel construct;
    @Mock
    private ConnectionProviderModel connectionProvider;
    @Mock
    private ParameterGroupModel groupModel;
    @Mock
    private ParameterModel parameterModel;
    @Mock
    private SourceModel source;
    @Mock
    private FunctionModel function;
    @Mock
    private SourceCallbackModel sourceCallback;

    @Before
    public void before() {
        Mockito.when((Object)this.source.getErrorCallback()).thenReturn(Optional.of(this.sourceCallback));
        Mockito.when((Object)this.source.getSuccessCallback()).thenReturn(Optional.of(this.sourceCallback));
        Mockito.when((Object)this.extension.getConfigurationModels()).thenReturn(Arrays.asList(this.configuration));
        Mockito.when((Object)this.extension.getOperationModels()).thenReturn(Arrays.asList(this.operation));
        Mockito.when((Object)this.extension.getSourceModels()).thenReturn(Arrays.asList(this.source));
        Mockito.when((Object)this.extension.getConstructModels()).thenReturn(Arrays.asList(this.construct));
        Mockito.when((Object)this.extension.getFunctionModels()).thenReturn(Arrays.asList(this.function));
        Mockito.when((Object)this.extension.getConnectionProviders()).thenReturn(Arrays.asList(this.connectionProvider));
        Mockito.when((Object)this.configuration.getOperationModels()).thenReturn(Arrays.asList(this.operation));
        Mockito.when((Object)this.configuration.getSourceModels()).thenReturn(Arrays.asList(this.source));
        Mockito.when((Object)this.configuration.getConnectionProviders()).thenReturn(Arrays.asList(this.connectionProvider));
        Mockito.when((Object)this.groupModel.getParameterModels()).thenReturn(Arrays.asList(this.parameterModel));
        this.addParameter(new ParameterizedModel[]{this.configuration, this.operation, this.construct, this.connectionProvider, this.source, this.sourceCallback});
        ExtensionModelTestUtils.visitableMock(new ComponentModel[]{this.operation, this.construct, this.source});
    }

    private void addParameter(ParameterizedModel ... models) {
        for (ParameterizedModel model : models) {
            Mockito.when((Object)model.getParameterGroupModels()).thenReturn(Arrays.asList(this.groupModel));
        }
    }

    @Test
    public void walk() {
        final AtomicInteger configs = new AtomicInteger(0);
        final AtomicInteger operations = new AtomicInteger(0);
        final AtomicInteger constructs = new AtomicInteger(0);
        final AtomicInteger functions = new AtomicInteger(0);
        final AtomicInteger sources = new AtomicInteger(0);
        final AtomicInteger parameterGroups = new AtomicInteger(0);
        final AtomicInteger parameters = new AtomicInteger(0);
        final AtomicInteger providers = new AtomicInteger(0);
        new ExtensionWalker(){

            public void onConfiguration(ConfigurationModel model) {
                configs.incrementAndGet();
            }

            public void onOperation(HasOperationModels owner, OperationModel model) {
                operations.incrementAndGet();
            }

            protected void onFunction(HasFunctionModels owner, FunctionModel model) {
                functions.incrementAndGet();
            }

            protected void onConstruct(HasConstructModels owner, ConstructModel model) {
                constructs.incrementAndGet();
            }

            public void onConnectionProvider(HasConnectionProviderModels owner, ConnectionProviderModel model) {
                providers.incrementAndGet();
            }

            public void onSource(HasSourceModels owner, SourceModel model) {
                sources.incrementAndGet();
            }

            public void onParameterGroup(ParameterizedModel owner, ParameterGroupModel model) {
                parameterGroups.incrementAndGet();
            }

            public void onParameter(ParameterizedModel owner, ParameterGroupModel groupModel, ParameterModel model) {
                Assert.assertThat((Object)groupModel, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)ExtensionWalkerTestCase.this.groupModel)));
                parameters.incrementAndGet();
            }
        }.walk(this.extension);
        this.assertCount(configs, 1);
        this.assertCount(operations, 2);
        this.assertCount(functions, 1);
        this.assertCount(constructs, 1);
        this.assertCount(sources, 2);
        this.assertCount(providers, 2);
        this.assertCount(parameterGroups, 12);
        this.assertCount(parameters, 12);
    }

    @Test
    public void defaultOperationWalk() {
        final AtomicInteger configs = new AtomicInteger(0);
        final AtomicInteger operations = new AtomicInteger(0);
        final AtomicInteger sources = new AtomicInteger(0);
        final AtomicInteger parameterGroups = new AtomicInteger(0);
        final AtomicInteger parameters = new AtomicInteger(0);
        final AtomicInteger providers = new AtomicInteger(0);
        new ExtensionWalker(){

            public void onConfiguration(ConfigurationModel model) {
                configs.incrementAndGet();
            }

            public void onOperation(HasOperationModels owner, OperationModel model) {
                operations.incrementAndGet();
            }

            public void onConnectionProvider(HasConnectionProviderModels owner, ConnectionProviderModel model) {
                providers.incrementAndGet();
            }

            public void onSource(HasSourceModels owner, SourceModel model) {
                sources.incrementAndGet();
            }

            public void onParameterGroup(ParameterizedModel owner, ParameterGroupModel model) {
                parameterGroups.incrementAndGet();
            }

            public void onParameter(ParameterizedModel owner, ParameterGroupModel groupModel, ParameterModel model) {
                Assert.assertThat((Object)groupModel, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)ExtensionWalkerTestCase.this.groupModel)));
                parameters.incrementAndGet();
            }
        }.walk(this.extension);
        this.assertCount(configs, 1);
        this.assertCount(operations, 2);
        this.assertCount(sources, 2);
        this.assertCount(providers, 2);
        this.assertCount(parameterGroups, 12);
        this.assertCount(parameters, 12);
    }

    @Test
    public void stopOnConfig() {
        final AtomicInteger configs = new AtomicInteger(0);
        final AtomicInteger operations = new AtomicInteger(0);
        final AtomicInteger sources = new AtomicInteger(0);
        final AtomicInteger parameterGroups = new AtomicInteger(0);
        final AtomicInteger parameters = new AtomicInteger(0);
        final AtomicInteger providers = new AtomicInteger(0);
        new ExtensionWalker(){

            public void onConfiguration(ConfigurationModel model) {
                configs.incrementAndGet();
                this.stop();
            }

            public void onOperation(HasOperationModels owner, OperationModel model) {
                operations.incrementAndGet();
            }

            public void onConnectionProvider(HasConnectionProviderModels owner, ConnectionProviderModel model) {
                providers.incrementAndGet();
            }

            public void onSource(HasSourceModels owner, SourceModel model) {
                sources.incrementAndGet();
            }

            public void onParameterGroup(ParameterizedModel owner, ParameterGroupModel model) {
                parameterGroups.incrementAndGet();
            }

            public void onParameter(ParameterizedModel owner, ParameterGroupModel groupModel, ParameterModel model) {
                Assert.assertThat((Object)groupModel, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)ExtensionWalkerTestCase.this.groupModel)));
                parameters.incrementAndGet();
            }
        }.walk(this.extension);
        this.assertCount(configs, 1);
        this.assertCount(operations, 0);
        this.assertCount(sources, 0);
        this.assertCount(providers, 0);
        this.assertCount(parameterGroups, 0);
        this.assertCount(parameters, 0);
    }

    @Test
    public void stopOnOperation() {
        final AtomicInteger configs = new AtomicInteger(0);
        final AtomicInteger operations = new AtomicInteger(0);
        final AtomicInteger sources = new AtomicInteger(0);
        final AtomicInteger parameterGroups = new AtomicInteger(0);
        final AtomicInteger parameters = new AtomicInteger(0);
        final AtomicInteger providers = new AtomicInteger(0);
        new ExtensionWalker(){

            public void onConfiguration(ConfigurationModel model) {
                configs.incrementAndGet();
            }

            public void onOperation(HasOperationModels owner, OperationModel model) {
                operations.incrementAndGet();
                this.stop();
            }

            public void onConnectionProvider(HasConnectionProviderModels owner, ConnectionProviderModel model) {
                providers.incrementAndGet();
            }

            public void onSource(HasSourceModels owner, SourceModel model) {
                sources.incrementAndGet();
            }

            public void onParameterGroup(ParameterizedModel owner, ParameterGroupModel model) {
                parameterGroups.incrementAndGet();
            }

            public void onParameter(ParameterizedModel owner, ParameterGroupModel groupModel, ParameterModel model) {
                Assert.assertThat((Object)groupModel, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)ExtensionWalkerTestCase.this.groupModel)));
                parameters.incrementAndGet();
            }
        }.walk(this.extension);
        this.assertCount(configs, 1);
        this.assertCount(operations, 1);
        this.assertCount(sources, 1);
        this.assertCount(providers, 1);
        this.assertCount(parameterGroups, 5);
        this.assertCount(parameters, 5);
    }

    @Test
    public void stopOnConnection() {
        final AtomicInteger configs = new AtomicInteger(0);
        final AtomicInteger operations = new AtomicInteger(0);
        final AtomicInteger sources = new AtomicInteger(0);
        final AtomicInteger parameterGroups = new AtomicInteger(0);
        final AtomicInteger parameters = new AtomicInteger(0);
        final AtomicInteger providers = new AtomicInteger(0);
        new ExtensionWalker(){

            public void onConfiguration(ConfigurationModel model) {
                configs.incrementAndGet();
            }

            public void onOperation(HasOperationModels owner, OperationModel model) {
                operations.incrementAndGet();
            }

            public void onConnectionProvider(HasConnectionProviderModels owner, ConnectionProviderModel model) {
                providers.incrementAndGet();
                this.stop();
            }

            public void onSource(HasSourceModels owner, SourceModel model) {
                sources.incrementAndGet();
            }

            public void onParameterGroup(ParameterizedModel owner, ParameterGroupModel model) {
                parameterGroups.incrementAndGet();
            }

            public void onParameter(ParameterizedModel owner, ParameterGroupModel groupModel, ParameterModel model) {
                Assert.assertThat((Object)groupModel, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)ExtensionWalkerTestCase.this.groupModel)));
                parameters.incrementAndGet();
            }
        }.walk(this.extension);
        this.assertCount(configs, 1);
        this.assertCount(operations, 0);
        this.assertCount(sources, 0);
        this.assertCount(providers, 1);
        this.assertCount(parameterGroups, 0);
        this.assertCount(parameters, 0);
    }

    @Test
    public void stopOnSource() {
        final AtomicInteger configs = new AtomicInteger(0);
        final AtomicInteger operations = new AtomicInteger(0);
        final AtomicInteger sources = new AtomicInteger(0);
        final AtomicInteger parameterGroups = new AtomicInteger(0);
        final AtomicInteger parameters = new AtomicInteger(0);
        final AtomicInteger providers = new AtomicInteger(0);
        new ExtensionWalker(){

            public void onConfiguration(ConfigurationModel model) {
                configs.incrementAndGet();
            }

            public void onOperation(HasOperationModels owner, OperationModel model) {
                operations.incrementAndGet();
            }

            public void onConnectionProvider(HasConnectionProviderModels owner, ConnectionProviderModel model) {
                providers.incrementAndGet();
            }

            public void onSource(HasSourceModels owner, SourceModel model) {
                sources.incrementAndGet();
                this.stop();
            }

            public void onParameterGroup(ParameterizedModel owner, ParameterGroupModel model) {
                parameterGroups.incrementAndGet();
            }

            public void onParameter(ParameterizedModel owner, ParameterGroupModel groupModel, ParameterModel model) {
                Assert.assertThat((Object)groupModel, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)ExtensionWalkerTestCase.this.groupModel)));
                parameters.incrementAndGet();
            }
        }.walk(this.extension);
        this.assertCount(configs, 1);
        this.assertCount(operations, 0);
        this.assertCount(sources, 1);
        this.assertCount(providers, 1);
        this.assertCount(parameterGroups, 2);
        this.assertCount(parameters, 2);
    }

    @Test
    public void stopOnGroup() {
        final AtomicInteger configs = new AtomicInteger(0);
        final AtomicInteger operations = new AtomicInteger(0);
        final AtomicInteger sources = new AtomicInteger(0);
        final AtomicInteger parameterGroups = new AtomicInteger(0);
        final AtomicInteger parameters = new AtomicInteger(0);
        final AtomicInteger providers = new AtomicInteger(0);
        new ExtensionWalker(){

            public void onConfiguration(ConfigurationModel model) {
                configs.incrementAndGet();
            }

            public void onOperation(HasOperationModels owner, OperationModel model) {
                operations.incrementAndGet();
            }

            public void onConnectionProvider(HasConnectionProviderModels owner, ConnectionProviderModel model) {
                providers.incrementAndGet();
            }

            public void onSource(HasSourceModels owner, SourceModel model) {
                sources.incrementAndGet();
            }

            public void onParameterGroup(ParameterizedModel owner, ParameterGroupModel model) {
                parameterGroups.incrementAndGet();
                this.stop();
            }

            public void onParameter(ParameterizedModel owner, ParameterGroupModel groupModel, ParameterModel model) {
                Assert.assertThat((Object)groupModel, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)ExtensionWalkerTestCase.this.groupModel)));
                parameters.incrementAndGet();
            }
        }.walk(this.extension);
        this.assertCount(configs, 1);
        this.assertCount(operations, 0);
        this.assertCount(sources, 0);
        this.assertCount(providers, 1);
        this.assertCount(parameterGroups, 1);
        this.assertCount(parameters, 0);
    }

    @Test
    public void stopOnParameter() {
        final AtomicInteger configs = new AtomicInteger(0);
        final AtomicInteger operations = new AtomicInteger(0);
        final AtomicInteger sources = new AtomicInteger(0);
        final AtomicInteger parameterGroups = new AtomicInteger(0);
        final AtomicInteger parameters = new AtomicInteger(0);
        final AtomicInteger providers = new AtomicInteger(0);
        new ExtensionWalker(){

            public void onConfiguration(ConfigurationModel model) {
                configs.incrementAndGet();
            }

            public void onOperation(HasOperationModels owner, OperationModel model) {
                operations.incrementAndGet();
            }

            public void onConnectionProvider(HasConnectionProviderModels owner, ConnectionProviderModel model) {
                providers.incrementAndGet();
            }

            public void onSource(HasSourceModels owner, SourceModel model) {
                sources.incrementAndGet();
            }

            public void onParameterGroup(ParameterizedModel owner, ParameterGroupModel model) {
                parameterGroups.incrementAndGet();
            }

            public void onParameter(ParameterizedModel owner, ParameterGroupModel groupModel, ParameterModel model) {
                Assert.assertThat((Object)groupModel, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)ExtensionWalkerTestCase.this.groupModel)));
                parameters.incrementAndGet();
                this.stop();
            }
        }.walk(this.extension);
        this.assertCount(configs, 1);
        this.assertCount(operations, 0);
        this.assertCount(sources, 0);
        this.assertCount(providers, 1);
        this.assertCount(parameterGroups, 1);
        this.assertCount(parameters, 1);
    }

    private void assertCount(AtomicInteger actual, int expected) {
        Assert.assertThat((Object)actual.get(), (Matcher)CoreMatchers.is((Object)expected));
    }
}

