/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.meta.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.app.declaration.serialization.ArtifactDeclarationJsonSerializer;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.app.declaration.api.ConnectionElementDeclaration;
import org.mule.runtime.app.declaration.api.GlobalElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterGroupElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterValue;
import org.mule.runtime.app.declaration.api.RouteElementDeclaration;
import org.mule.runtime.app.declaration.api.fluent.ArtifactDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ConfigurationElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ConnectionElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ConstructElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.OperationElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.RouteElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.SourceElementDeclarer;

public class ArtifactDeclarationJsonSerializerTestCase {
    private static final String EXPECTED_ARTIFACT_DECLARATION_JSON = "declaration/artifact-declaration.json";
    private ArtifactDeclaration applicationDeclaration;

    @Before
    public void setup() {
        this.applicationDeclaration = this.createArtifact();
    }

    @Test
    public void serializationTest() {
        JsonParser parser = new JsonParser();
        JsonReader reader = new JsonReader((Reader)new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream(EXPECTED_ARTIFACT_DECLARATION_JSON)));
        JsonElement expected = parser.parse(reader);
        JsonElement json = parser.parse(ArtifactDeclarationJsonSerializer.getDefault((boolean)true).serialize(this.applicationDeclaration));
        MatcherAssert.assertThat((Object)json, (Matcher)CoreMatchers.is((Matcher)Matchers.equalTo((Object)expected)));
    }

    @Test
    public void serializeDeserializeTest() {
        ArtifactDeclarationJsonSerializer serializer = ArtifactDeclarationJsonSerializer.getDefault((boolean)true);
        String json = serializer.serialize(this.applicationDeclaration);
        ArtifactDeclaration artifactDeclaration = serializer.deserialize(json);
        MatcherAssert.assertThat((String)json, (Object)this.applicationDeclaration, (Matcher)CoreMatchers.is((Matcher)Matchers.equalTo((Object)artifactDeclaration)));
    }

    private ArtifactDeclaration createArtifact() {
        ElementDeclarer core = ElementDeclarer.forExtension((String)"mule");
        ElementDeclarer db = ElementDeclarer.forExtension((String)"Database");
        ElementDeclarer http = ElementDeclarer.forExtension((String)"HTTP");
        ElementDeclarer sockets = ElementDeclarer.forExtension((String)"Sockets");
        ElementDeclarer wsc = ElementDeclarer.forExtension((String)"Web Service Consumer");
        ElementDeclarer file = ElementDeclarer.forExtension((String)"File");
        ElementDeclarer os = ElementDeclarer.forExtension((String)"ObjectStore");
        return (ArtifactDeclaration)((ArtifactDeclarer)ElementDeclarer.newArtifact().withCustomParameter("xmlns:doc", "http://www.mulesoft.org/schema/mule/documentation")).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)core.newConstruct("configuration").withParameterGroup(group -> group.withParameter("defaultErrorHandler-ref", "referableHandler"))).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)core.newConstruct("errorHandler").withRefName("referableHandler").withComponent((ComponentElementDeclaration)((RouteElementDeclarer)core.newRoute("onErrorContinue").withParameterGroup(group -> group.withParameter("type", "MULE:SOURCE_RESPONSE").withParameter("logException", "false").withParameter("enableNotifications", "false"))).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)core.newOperation("logger").withParameterGroup(group -> group.withParameter("level", "TRACE"))).getDeclaration()).getDeclaration())).getDeclaration()).withGlobalElement((GlobalElementDeclaration)os.newGlobalParameter("objectStore").withRefName("persistentStore").withValue(ElementDeclarer.newObjectValue().ofType("org.mule.extension.objectstore.api.TopLevelObjectStore").withParameter("entryTtl", "1").withParameter("entryTtlUnit", "HOURS").withParameter("maxEntries", "10").withParameter("persistent", "true").withParameter("expirationInterval", "2").withParameter("expirationIntervalUnit", "HOURS").withParameter("config-ref", "persistentConfig").build()).getDeclaration()).withGlobalElement((GlobalElementDeclaration)os.newConfiguration("config").withRefName("persistentConfig").getDeclaration()).withGlobalElement((GlobalElementDeclaration)file.newConfiguration("config").withRefName("fileConfig").withConnection((ConnectionElementDeclaration)file.newConnection("connection").getDeclaration()).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConfigurationElementDeclarer)wsc.newConfiguration("config").withRefName("wscConfig").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("expirationPolicy", (ParameterValue)ElementDeclarer.newObjectValue().ofType("org.mule.runtime.extension.api.ExpirationPolicy").withParameter("maxIdleTime", "1").withParameter("timeUnit", TimeUnit.MINUTES.name()).build()).getDeclaration())).withConnection((ConnectionElementDeclaration)((ConnectionElementDeclarer)((ConnectionElementDeclarer)wsc.newConnection("connection").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("soapVersion", "SOAP11").withParameter("mtomEnabled", "false").getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Connection").withParameter("wsdlLocation", "http://www.webservicex.com/globalweather.asmx?WSDL").withParameter("address", "http://www.webservicex.com/globalweather.asmx").withParameter("service", "GlobalWeather").withParameter("port", "GlobalWeatherSoap").getDeclaration())).getDeclaration()).getDeclaration()).withGlobalElement((GlobalElementDeclaration)db.newConfiguration("config").withRefName("dbConfig").withConnection((ConnectionElementDeclaration)((ConnectionElementDeclarer)((ConnectionElementDeclarer)db.newConnection("derby").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("poolingProfile", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("maxPoolSize", "10").build()).getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Connection").withParameter("connectionProperties", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("first", "propertyOne").withParameter("second", "propertyTwo").build()).withParameter("reconnection", (ParameterValue)ElementDeclarer.newObjectValue().ofType("Reconnection").withParameter("failsDeployment", "true").withParameter("reconnectionStrategy", (ParameterValue)ElementDeclarer.newObjectValue().ofType("reconnect").withParameter("count", "1").withParameter("frequency", "0").build()).build()).withParameter("database", "target/muleEmbeddedDB").withParameter("create", "true").getDeclaration())).getDeclaration()).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConfigurationElementDeclarer)http.newConfiguration("listenerConfig").withRefName("httpListener").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("basePath", "/").getDeclaration())).withConnection((ConnectionElementDeclaration)((ConnectionElementDeclarer)((ConnectionElementDeclarer)http.newConnection("listener").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("tlsContext", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("key-store", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("path", "ssltest-keystore.jks").withParameter("password", "changeit").withParameter("keyPassword", "changeit").build()).withParameter("trust-store", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("insecure", "true").build()).withParameter("revocation-check", (ParameterValue)ElementDeclarer.newObjectValue().ofType("standard-revocation-check").withParameter("onlyEndEntities", "true").build()).build()).getDeclaration())).withParameterGroup(group -> group.withName("Connection").withParameter("host", "localhost").withParameter("port", "49019").withParameter("protocol", "HTTPS"))).getDeclaration()).getDeclaration()).withGlobalElement((GlobalElementDeclaration)http.newConfiguration("requestConfig").withRefName("httpRequester").withConnection((ConnectionElementDeclaration)((ConnectionElementDeclarer)((ConnectionElementDeclarer)http.newConnection("request").withParameterGroup(group -> group.withParameter("authentication", (ParameterValue)ElementDeclarer.newObjectValue().ofType("org.mule.extension.http.api.request.authentication.BasicAuthentication").withParameter("username", "user").withParameter("password", "pass").build()))).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Connection").withParameter("host", "localhost").withParameter("port", "49020").withParameter("clientSocketProperties", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("connectionTimeout", "1000").withParameter("keepAlive", "true").withParameter("receiveBufferSize", "1024").withParameter("sendBufferSize", "1024").withParameter("clientTimeout", "1000").withParameter("linger", "1000").build()).getDeclaration())).getDeclaration()).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)((ConstructElementDeclarer)((ConstructElementDeclarer)((ConstructElementDeclarer)((ConstructElementDeclarer)((ConstructElementDeclarer)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("flow").withRefName("testFlow").withCustomParameter("doc:id", "docUUID")).withParameterGroup(group -> group.withParameter("initialState", "stopped"))).withComponent((ComponentElementDeclaration)((SourceElementDeclarer)((SourceElementDeclarer)((SourceElementDeclarer)((SourceElementDeclarer)((SourceElementDeclarer)http.newSource("listener").withConfig("httpListener")).withCustomParameter("doc:id", "docUUID")).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("path", "testBuilder").withParameter("redeliveryPolicy", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("maxRedeliveryCount", "2").withParameter("useSecureHash", "true").build()).getDeclaration())).withParameterGroup(group -> group.withName("Connection").withParameter("reconnectionStrategy", (ParameterValue)ElementDeclarer.newObjectValue().ofType("reconnect").withParameter("count", "1").withParameter("frequency", "0").build()))).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Response").withParameter("headers", "<![CDATA[#[{{'content-type' : 'text/plain'}}]]]>").withParameter("body", "<![CDATA[#[\n                    %dw 2.0\n                    output application/json\n                    input payload application/xml\n                    var baseUrl=\"http://sample.cloudhub.io/api/v1.0/\"\n                    ---\n                    using (pageSize = payload.getItemsResponse.PageInfo.pageSize) {\n                         links: [\n                            {\n                                href: fullUrl,\n                                rel : \"self\"\n                            }\n                         ],\n                         collection: {\n                            size: pageSize,\n                            items: payload.getItemsResponse.*Item map {\n                                id: $.id,\n                                type: $.type,\n                                name: $.name\n                            }\n                         }\n                    }\n                ]]>").getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("choice").withRoute((RouteElementDeclaration)((RouteElementDeclarer)core.newRoute("when").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("expression", "#[true]").getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)db.newOperation("bulkInsert").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Query").withParameter("sql", "INSERT INTO PLANET(POSITION, NAME) VALUES (:position, :name)").withParameter("parameterTypes", (ParameterValue)ElementDeclarer.newListValue().withValue((ParameterValue)ElementDeclarer.newObjectValue().withParameter("key", "name").withParameter("type", "VARCHAR").build()).withValue((ParameterValue)ElementDeclarer.newObjectValue().withParameter("key", "position").withParameter("type", "INTEGER").build()).build()).getDeclaration())).getDeclaration()).getDeclaration())).withRoute((RouteElementDeclaration)core.newRoute("otherwise").withComponent((ComponentElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("foreach").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("collection", "#[myCollection]").getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)core.newOperation("logger").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("message", "#[payload]").getDeclaration())).getDeclaration())).getDeclaration()).getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)db.newOperation("bulkInsert").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Query").withParameter("sql", "INSERT INTO PLANET(POSITION, NAME) VALUES (:position, :name)").withParameter("parameterTypes", (ParameterValue)ElementDeclarer.newListValue().withValue((ParameterValue)ElementDeclarer.newObjectValue().withParameter("key", "name").withParameter("type", "VARCHAR").build()).withValue((ParameterValue)ElementDeclarer.newObjectValue().withParameter("key", "position").withParameter("type", "INTEGER").build()).build()).getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)((OperationElementDeclarer)http.newOperation("request").withConfig("httpRequester")).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"URI Settings").withParameter("path", "/nested").getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("method", "POST").getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)db.newOperation("insert").withConfig("dbConfig")).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Query").withParameter("sql", "INSERT INTO PLANET(POSITION, NAME, DESCRIPTION) VALUES (777, 'Pluto', :description)").withParameter("parameterTypes", (ParameterValue)ElementDeclarer.newListValue().withValue((ParameterValue)ElementDeclarer.newObjectValue().withParameter("key", "description").withParameter("type", "CLOB").build()).build()).withParameter("inputParameters", "#[{{'description' : payload}}]").getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)sockets.newOperation("sendAndReceive").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("streamingStrategy", (ParameterValue)ElementDeclarer.newObjectValue().ofType("repeatable-in-memory-stream").withParameter("bufferSizeIncrement", "8").withParameter("bufferUnit", "KB").withParameter("initialBufferSize", "51").withParameter("maxBufferSize", "1000").build()).getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Output").withParameter("target", "myVar").withParameter("targetValue", "#[message]").getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("try").withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)wsc.newOperation("consume").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("operation", "GetCitiesByCountry").getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Message").withParameter("attachments", "#[{}]").withParameter("headers", "#[{\"headers\": {con#headerIn: \"Header In Value\",con#headerInOut: \"Header In Out Value\"}]").withParameter("body", "#[payload]").getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("errorHandler").withComponent((ComponentElementDeclaration)((RouteElementDeclarer)core.newRoute("onErrorContinue").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("type", "MULE:ANY").getDeclaration())).withComponent((ComponentElementDeclaration)core.newOperation("logger").getDeclaration()).getDeclaration())).withComponent((ComponentElementDeclaration)((RouteElementDeclarer)core.newRoute("onErrorPropagate").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("type", "WSC:CONNECTIVITY").withParameter("when", "#[e.cause == null]").getDeclaration())).getDeclaration())).getDeclaration())).getDeclaration())).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("flow").withRefName("schedulerFlow").withComponent((ComponentElementDeclaration)((SourceElementDeclarer)core.newSource("scheduler").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("schedulingStrategy", (ParameterValue)ElementDeclarer.newObjectValue().ofType("org.mule.runtime.core.api.source.scheduler.FixedFrequencyScheduler").withParameter("frequency", "50").withParameter("startDelay", "20").withParameter("timeUnit", "SECONDS").build()).getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)core.newOperation("logger").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("message", "#[payload]").getDeclaration())).getDeclaration())).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("flow").withRefName("cronSchedulerFlow").withComponent((ComponentElementDeclaration)((SourceElementDeclarer)core.newSource("scheduler").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("schedulingStrategy", (ParameterValue)ElementDeclarer.newObjectValue().ofType("org.mule.runtime.core.api.source.scheduler.CronScheduler").withParameter("expression", "0/1 * * * * ?").build()).getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)core.newOperation("logger").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("message", "#[payload]").getDeclaration())).getDeclaration())).getDeclaration()).getDeclaration();
    }
}

