/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.el;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.el.ModuleNamespace;

public class ModuleNamespaceTestCase {
    @Test
    public void shouldNormalizeNamespaceFromCamelCase() throws Exception {
        Assert.assertThat((Object)new ModuleNamespace(new String[]{"myCamelCase"}).toString(), (Matcher)Is.is((Object)"MyCamelCase"));
    }

    @Test
    public void shouldNormalizeNamespaceFromHyphenized() throws Exception {
        Assert.assertThat((Object)new ModuleNamespace(new String[]{"my-hyphen-Case"}).toString(), (Matcher)Is.is((Object)"MyHyphenCase"));
    }

    @Test
    public void shouldNormalizeNamespaceWithNumbers() throws Exception {
        Assert.assertThat((Object)new ModuleNamespace(new String[]{"my 29 name I18n with  num 3 rs or numb3rs"}).toString(), (Matcher)Is.is((Object)"My29NameI18nWithNum3RsOrNumb3rs"));
    }

    @Test
    public void shouldNormalizeNamespaceFromBlanks() throws Exception {
        Assert.assertThat((Object)new ModuleNamespace(new String[]{"my", "name", "I18n with  blanks"}).toString(), (Matcher)Is.is((Object)"my::name::I18nWithBlanks"));
    }

    @Test
    public void shouldNormalizeNamespace() throws Exception {
        Assert.assertThat((Object)new ModuleNamespace(new String[]{"_prefix", "munit-tools", "myName-with  22", "1o", "20", "mixedContent-pascal"}).toString(), (Matcher)Is.is((Object)"prefix::munittools::mynamewith22::1o::20::MixedContentPascal"));
    }
}

