/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.util;

import java.util.Iterator;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.util.CaseInsensitiveMapWrapper;

public class CaseInsensitiveMapWrapperTestCase {
    private Map<String, Integer> map;

    @Before
    public void initializeMap() {
        this.map = new CaseInsensitiveMapWrapper();
    }

    @Test
    public void getIsCaseInsensitive() {
        this.map.put("A", 1);
        Assert.assertThat((Object)this.map.keySet().size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)this.map.get("a"), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)this.map.get("A"), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)this.map.get("b"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void keySetIsCaseInsensitive() {
        this.map.put("A", 1);
        Assert.assertThat((Object)this.map.keySet().contains("a"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.map.keySet().contains("A"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.map.keySet().contains("b"), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void retainKeyCase() {
        this.map.put("A", 1);
        Assert.assertThat((Object)this.map.keySet().iterator().next(), (Matcher)Matchers.equalToIgnoringCase((String)"A"));
    }

    @Test
    public void clearFromKeySet() {
        this.map.put("A", 1);
        this.map.keySet().clear();
        Assert.assertThat((Object)this.map.size(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void clearFromEntrySet() {
        this.map.put("A", 1);
        this.map.entrySet().clear();
        Assert.assertThat((Object)this.map.size(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void removeFromKeySetIterator() {
        this.map.put("A", 1);
        this.map.put("B", 2);
        this.map.put("C", 3);
        Assert.assertThat((Object)this.map.size(), (Matcher)Matchers.is((Object)3));
        Iterator<String> it = this.map.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next();
            if (!key.equalsIgnoreCase("B")) continue;
            it.remove();
        }
        Assert.assertThat((Object)this.map.size(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)this.map.get("a"), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)this.map.get("b"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)this.map.get("c"), (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void removeFromEntrySetIterator() {
        this.map.put("A", 1);
        this.map.put("B", 2);
        this.map.put("C", 3);
        Assert.assertThat((Object)this.map.size(), (Matcher)Matchers.is((Object)3));
        Iterator<Map.Entry<String, Integer>> it = this.map.entrySet().iterator();
        while (it.hasNext()) {
            String key = it.next().getKey();
            if (!key.equalsIgnoreCase("B")) continue;
            it.remove();
        }
        Assert.assertThat((Object)this.map.size(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)this.map.get("a"), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)this.map.get("b"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)this.map.get("c"), (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void containsKey() {
        this.map.put("A", 1);
        Assert.assertThat((Object)this.map.containsKey("A"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.map.containsKey("a"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.map.containsKey("B"), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void containsValue() {
        this.map.put("A", 1);
        Assert.assertThat((Object)this.map.containsValue(1), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.map.containsValue("a"), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)this.map.containsValue(2), (Matcher)Matchers.is((Object)false));
    }
}

