/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.util;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.util.LazyLong;

public class LazyLongTestCase {
    private LazyLong lazy;

    @Test
    public void computeOnlyOnce() {
        AtomicInteger count = new AtomicInteger(0);
        this.lazy = new LazyLong(() -> {
            count.incrementAndGet();
            return 8L;
        });
        long value = this.lazy.getAsLong();
        Assert.assertThat((Object)this.lazy.getAsLong(), (Matcher)CoreMatchers.is((Object)value));
        Assert.assertThat((Object)count.get(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void isInitialised() {
        this.lazy = new LazyLong(() -> 8L);
        Assert.assertThat((Object)this.lazy.isComputed(), (Matcher)CoreMatchers.is((Object)false));
        this.lazy.getAsLong();
        Assert.assertThat((Object)this.lazy.isComputed(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test(expected=IllegalArgumentException.class)
    public void nullSupplier() {
        new LazyLong(null);
    }

    @Test
    public void concurrentInitialisation() throws Exception {
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        long value = 8L;
        AtomicInteger invocationCount = new AtomicInteger(0);
        AtomicReference<Object> value1 = new AtomicReference<Object>(null);
        AtomicReference<Object> value2 = new AtomicReference<Object>(null);
        LazyLong lazy = new LazyLong(() -> {
            invocationCount.addAndGet(1);
            return 8L;
        });
        Thread thread1 = new Thread(() -> {
            latch1.countDown();
            this.await(latch2);
            value1.set(lazy.getAsLong());
        });
        Thread thread2 = new Thread(() -> {
            this.await(latch1);
            latch2.countDown();
            value2.set(lazy.getAsLong());
        });
        thread1.start();
        thread2.start();
        thread1.join(1000L);
        thread2.join(1000L);
        Assert.assertThat((Object)invocationCount.get(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat(value1.get(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance(value2.get())));
        Assert.assertThat(value1.get(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)8L)));
    }

    private void await(CountDownLatch latch) {
        try {
            latch.await(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

