/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.api.tx.xa;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessage;

/**
 * Exception related to transactional resources' errors.
 *
 * @since 1.10
 */
public class ResourceManagerException extends MuleException {

  private static final long serialVersionUID = -2710661653314559258L;

  public ResourceManagerException() {
    super();
  }

  public ResourceManagerException(I18nMessage message) {
    super(message);
  }

  public ResourceManagerException(Throwable cause) {
    super(cause);
  }

  public ResourceManagerException(I18nMessage message, Throwable cause) {
    super(message, cause);
  }

}
