/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.test.meta.model.declaration.fuent;

import io.qameta.allure.Issue;
import java.util.HashSet;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.model.declaration.fluent.ConstructDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConstructDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclarer;

public class ExtensionDeclarerTestCase {
    @Test
    @Issue(value="MULE-19701")
    public void registerGatewayTypes() {
        String gwTypeFqcn = "com.mulesoft.mule.runtime.gw.GatewayType";
        ObjectType gwObjectType = (ObjectType)Mockito.mock(ObjectType.class);
        Mockito.when((Object)gwObjectType.getAnnotation(TypeIdAnnotation.class)).thenReturn(Optional.of(new TypeIdAnnotation(gwTypeFqcn)));
        ((ObjectType)Mockito.doAnswer(inv -> {
            MetadataTypeVisitor v = (MetadataTypeVisitor)inv.getArgument(0);
            v.visitObject((ObjectType)inv.getMock());
            return null;
        }).when((Object)gwObjectType)).accept((MetadataTypeVisitor)ArgumentMatchers.any());
        ExtensionDeclarer declarer = new ExtensionDeclarer();
        declarer.withType(gwObjectType);
        MatcherAssert.assertThat((Object)((ExtensionDeclaration)declarer.getDeclaration()).getTypeById(gwTypeFqcn), (Matcher)CoreMatchers.sameInstance((Object)gwObjectType));
    }

    @Test
    public void setExtensionName() {
        ExtensionDeclarer declarer = new ExtensionDeclarer();
        String extensionName = "TestExtension";
        declarer.named(extensionName);
        MatcherAssert.assertThat((Object)((ExtensionDeclaration)declarer.getDeclaration()).getName(), (Matcher)Is.is((Object)extensionName));
    }

    @Test
    public void setExtensionVersion() {
        ExtensionDeclarer declarer = new ExtensionDeclarer();
        String version = "1.0.0";
        declarer.onVersion(version);
        MatcherAssert.assertThat((Object)((ExtensionDeclaration)declarer.getDeclaration()).getVersion(), (Matcher)Is.is((Object)version));
    }

    @Test
    public void setExtensionDescription() {
        ExtensionDeclarer declarer = new ExtensionDeclarer();
        String description = "This is a test extension.";
        declarer.describedAs(description);
        MatcherAssert.assertThat((Object)((ExtensionDeclaration)declarer.getDeclaration()).getDescription(), (Matcher)Is.is((Object)description));
    }

    @Test
    public void addPrivilegedPackage() {
        ExtensionDeclarer declarer = new ExtensionDeclarer();
        String packageName = "org.mule.runtime.privileged";
        declarer.withPrivilegedPackage(packageName);
        MatcherAssert.assertThat((Object)((ExtensionDeclaration)declarer.getDeclaration()).getPrivilegedPackages(), (Matcher)Matchers.hasItem((Object)packageName));
    }

    @Test
    public void addPrivilegedArtifact() {
        ExtensionDeclarer declarer = new ExtensionDeclarer();
        String artifactId = "privileged-artifact";
        declarer.withPrivilegedArtifact(artifactId);
        MatcherAssert.assertThat((Object)((ExtensionDeclaration)declarer.getDeclaration()).getPrivilegedArtifacts(), (Matcher)Matchers.hasItem((Object)artifactId));
    }

    @Test
    public void addSupportedJavaVersions() {
        ExtensionDeclarer declarer = new ExtensionDeclarer();
        HashSet<String> javaVersions = new HashSet<String>();
        javaVersions.add("11");
        javaVersions.add("17");
        declarer.supportingJavaVersions(javaVersions);
        MatcherAssert.assertThat((Object)((ExtensionDeclaration)declarer.getDeclaration()).getSupportedJavaVersions(), (Matcher)Is.is(javaVersions));
    }

    @Test
    public void setExtensionCategory() {
        ExtensionDeclarer declarer = new ExtensionDeclarer();
        Category category = Category.COMMUNITY;
        declarer.withCategory(category);
        MatcherAssert.assertThat((Object)((ExtensionDeclaration)declarer.getDeclaration()).getCategory(), (Matcher)Is.is((Object)category));
    }

    @Test
    public void handleNullExtensionName() {
        ExtensionDeclarer declarer = new ExtensionDeclarer();
        declarer.named(null);
        MatcherAssert.assertThat((Object)((ExtensionDeclaration)declarer.getDeclaration()).getName(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void handleEmptyExtensionDescription() {
        ExtensionDeclarer declarer = new ExtensionDeclarer();
        String description = "";
        declarer.describedAs(description);
        MatcherAssert.assertThat((Object)((ExtensionDeclaration)declarer.getDeclaration()).getDescription(), (Matcher)Is.is((Object)description));
    }

    @Test
    public void handleDuplicatePrivilegedPackages() {
        ExtensionDeclarer declarer = new ExtensionDeclarer();
        String packageName = "org.mule.runtime.privileged";
        declarer.withPrivilegedPackage(packageName);
        declarer.withPrivilegedPackage(packageName);
        MatcherAssert.assertThat((Object)((ExtensionDeclaration)declarer.getDeclaration()).getPrivilegedPackages().size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void handleEmptySupportedJavaVersions() {
        ExtensionDeclarer declarer = new ExtensionDeclarer();
        HashSet javaVersions = new HashSet();
        declarer.supportingJavaVersions(javaVersions);
        MatcherAssert.assertThat((Object)((ExtensionDeclaration)declarer.getDeclaration()).getSupportedJavaVersions().isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void handleNullCategory() {
        ExtensionDeclarer declarer = new ExtensionDeclarer();
        declarer.withCategory(null);
        MatcherAssert.assertThat((Object)((ExtensionDeclaration)declarer.getDeclaration()).getCategory(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void testWithConstruct() {
        ConstructDeclarer constructDeclarer = (ConstructDeclarer)Mockito.mock(ConstructDeclarer.class);
        ConstructDeclaration constructDeclaration = (ConstructDeclaration)Mockito.mock(ConstructDeclaration.class);
        Mockito.when((Object)((ConstructDeclaration)constructDeclarer.getDeclaration())).thenReturn((Object)constructDeclaration);
        ExtensionDeclarer declarer = new ExtensionDeclarer();
        declarer.withConstruct(constructDeclarer);
        MatcherAssert.assertThat((Object)((ExtensionDeclaration)declarer.getDeclaration()).getConstructs(), (Matcher)Matchers.hasItem((Object)constructDeclaration));
    }

    @Test
    public void testWithOperation() {
        OperationDeclarer operationDeclarer = (OperationDeclarer)Mockito.mock(OperationDeclarer.class);
        OperationDeclaration operationDeclaration = (OperationDeclaration)Mockito.mock(OperationDeclaration.class);
        Mockito.when((Object)((OperationDeclaration)operationDeclarer.getDeclaration())).thenReturn((Object)operationDeclaration);
        ExtensionDeclarer declarer = new ExtensionDeclarer();
        declarer.withOperation(operationDeclarer);
        MatcherAssert.assertThat((Object)((ExtensionDeclaration)declarer.getDeclaration()).getOperations(), (Matcher)Matchers.hasItem((Object)operationDeclaration));
    }

    @Test
    public void testWithMessageSource() {
        SourceDeclarer sourceDeclarer = (SourceDeclarer)Mockito.mock(SourceDeclarer.class);
        SourceDeclaration sourceDeclaration = (SourceDeclaration)Mockito.mock(SourceDeclaration.class);
        Mockito.when((Object)((SourceDeclaration)sourceDeclarer.getDeclaration())).thenReturn((Object)sourceDeclaration);
        ExtensionDeclarer declarer = new ExtensionDeclarer();
        declarer.withMessageSource(sourceDeclarer);
        MatcherAssert.assertThat((Object)((ExtensionDeclaration)declarer.getDeclaration()).getMessageSources(), (Matcher)Matchers.hasItem((Object)sourceDeclaration));
    }
}

