/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.test.util;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.util.Reference;

public class ReferenceTestCase {
    @Test
    public void get() {
        Object value = new Object();
        Reference ref = new Reference(value);
        Assert.assertThat((Object)ref.get(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)value)));
    }

    @Test
    public void set() {
        Reference ref = new Reference(new Object());
        Object value = new Object();
        ref.set(value);
        Assert.assertThat((Object)ref.get(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)value)));
    }

    @Test
    public void setNull() {
        Reference ref = new Reference(new Object());
        ref.set(null);
        Assert.assertThat((Object)ref.get(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void setAndGet() {
        String value = "Hello";
        Reference reference = new Reference();
        Assert.assertThat((Object)((String)reference.set((Object)value)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)((String)reference.get()), (Matcher)CoreMatchers.is((Object)value));
    }

    @Test
    public void valueHashCode() {
        Object value = new Object();
        Reference ref = new Reference(value);
        Assert.assertThat((Object)ref.hashCode(), (Matcher)CoreMatchers.is((Object)value.hashCode()));
    }

    @Test
    public void defaultsToNull() {
        Assert.assertThat((Object)new Reference().get(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void getFromNullReference() {
        Assert.assertThat((Object)new Reference(null).get(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void nullValueHashCode() {
        Assert.assertThat((Object)new Reference(null).hashCode(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void equalReferences() {
        Object value = new Object();
        this.assertEquals(new Reference(value), new Reference(value));
    }

    @Test
    public void equalNullReferences() {
        this.assertEquals(new Reference(null), new Reference(null));
    }

    @Test
    public void equalMixedReferences() {
        this.assertNotEquals(new Reference(null), new Reference(new Object()));
        this.assertNotEquals(new Reference(new Object()), new Reference(null));
    }

    @Test
    public void notEqualReferences() {
        this.assertNotEquals(new Reference(new Object()), new Reference(new Object()));
    }

    private <T> void assertEquals(Reference<T> ref1, Reference<T> ref2) {
        Assert.assertThat(ref1, (Matcher)CoreMatchers.equalTo(ref2));
        Assert.assertThat((Object)ref1.hashCode(), (Matcher)CoreMatchers.is((Object)ref2.hashCode()));
    }

    private <T> void assertNotEquals(Reference<T> ref1, Reference<T> ref2) {
        Assert.assertThat(ref1, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo(ref2)));
        Assert.assertThat((Object)ref1.hashCode(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)ref2.hashCode())));
    }
}

