/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.api.artifact;

/**
 * Provides values for different types of artifacts that a Mule container may be able to handle.
 *
 * @since 1.9
 */
public enum ArtifactType {

  APP("app", true, "mule-application"),

  DOMAIN("domain", true, "mule-domain"),

  PLUGIN("plugin", false, "mule-plugin"),

  POLICY("policy", true, "mule-policy"),

  MULE_EXTENSION("muleExtension", false, "mule-extension"),

  SERVICE("service", false, "mule-service"),

  SERVER_PLUGIN("serverPlugin", false, "mule-server-plugin");

  private final String artifactTypeAsString;
  private final boolean deployable;
  private final String mavenArtifactClassifier;

  ArtifactType(String artifactTypeAsString, boolean deployable, String mavenArtifactClassifier) {
    this.artifactTypeAsString = artifactTypeAsString;
    this.deployable = deployable;
    this.mavenArtifactClassifier = mavenArtifactClassifier;
  }

  public String getArtifactTypeAsString() {
    return artifactTypeAsString;
  }

  /**
   * @return {@code true} if artifacts of this type are deployable units to a Mule container
   */
  public boolean isDeployable() {
    return deployable;
  }

  /**
   * @return the descriptor used in Maven to refer to this kind of artifact.
   *
   * @since 4.11
   */
  public String getMavenArtifactClassifier() {
    return mavenArtifactClassifier;
  }
}
