/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.metadata;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.api.metadata.MediaType;

public class MediaTypeTestCase {
    @Rule
    public ExpectedException expected = ExpectedException.none();

    @Test
    public void onlyMimeType() {
        MediaType parsed = MediaType.parse((String)"m/s");
        Assert.assertThat((Object)parsed.getPrimaryType(), (Matcher)CoreMatchers.is((Object)"m"));
        Assert.assertThat((Object)parsed.getSubType(), (Matcher)CoreMatchers.is((Object)"s"));
        Assert.assertThat((Object)parsed.getCharset().isPresent(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)parsed.getParameter(""), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)parsed.toRfcString(), (Matcher)CoreMatchers.is((Object)"m/s"));
        Assert.assertThat((Object)parsed.isDefinedInApp(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void mimeTypeAndCharset() {
        MediaType parsed = MediaType.parse((String)"m/s; charset=UTF-8");
        Assert.assertThat((Object)parsed.getPrimaryType(), (Matcher)CoreMatchers.is((Object)"m"));
        Assert.assertThat((Object)parsed.getSubType(), (Matcher)CoreMatchers.is((Object)"s"));
        Assert.assertThat(parsed.getCharset().get(), (Matcher)CoreMatchers.is((Object)StandardCharsets.UTF_8));
        Assert.assertThat((Object)parsed.getParameter("charset"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)parsed.getParameter(""), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)parsed.toRfcString(), (Matcher)CoreMatchers.is((Object)"m/s; charset=UTF-8"));
        Assert.assertThat((Object)parsed.isDefinedInApp(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void mimeTypeAndParams() {
        MediaType parsed = MediaType.parse((String)"m/s; param1=value1; param2=value2");
        Assert.assertThat((Object)parsed.getPrimaryType(), (Matcher)CoreMatchers.is((Object)"m"));
        Assert.assertThat((Object)parsed.getSubType(), (Matcher)CoreMatchers.is((Object)"s"));
        Assert.assertThat((Object)parsed.getCharset().isPresent(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)parsed.getParameter("param1"), (Matcher)CoreMatchers.is((Object)"value1"));
        Assert.assertThat((Object)parsed.getParameter("param2"), (Matcher)CoreMatchers.is((Object)"value2"));
        Assert.assertThat((Object)parsed.getParameter(""), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)parsed.toRfcString(), (Matcher)CoreMatchers.is((Object)"m/s; param1=\"value1\"; param2=\"value2\""));
        Assert.assertThat((Object)parsed.isDefinedInApp(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void mimeTypeCharsetAndParams() {
        MediaType parsed = MediaType.parse((String)"m/s; param1=value1; param2=value2; charset=UTF-8");
        Assert.assertThat((Object)parsed.getPrimaryType(), (Matcher)CoreMatchers.is((Object)"m"));
        Assert.assertThat((Object)parsed.getSubType(), (Matcher)CoreMatchers.is((Object)"s"));
        Assert.assertThat(parsed.getCharset().get(), (Matcher)CoreMatchers.is((Object)StandardCharsets.UTF_8));
        Assert.assertThat((Object)parsed.getParameter("charset"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)parsed.getParameter("param1"), (Matcher)CoreMatchers.is((Object)"value1"));
        Assert.assertThat((Object)parsed.getParameter("param2"), (Matcher)CoreMatchers.is((Object)"value2"));
        Assert.assertThat((Object)parsed.getParameter(""), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)parsed.toRfcString(), (Matcher)CoreMatchers.is((Object)"m/s; charset=UTF-8; param1=\"value1\"; param2=\"value2\""));
        Assert.assertThat((Object)parsed.isDefinedInApp(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void mimeTypeCharsetAndParamsDefinedInApp() {
        MediaType parsed = MediaType.parseDefinedInApp((String)"m/s; param1=value1; param2=value2; charset=UTF-8");
        Assert.assertThat((Object)parsed.getPrimaryType(), (Matcher)CoreMatchers.is((Object)"m"));
        Assert.assertThat((Object)parsed.getSubType(), (Matcher)CoreMatchers.is((Object)"s"));
        Assert.assertThat(parsed.getCharset().get(), (Matcher)CoreMatchers.is((Object)StandardCharsets.UTF_8));
        Assert.assertThat((Object)parsed.getParameter("charset"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)parsed.getParameter("param1"), (Matcher)CoreMatchers.is((Object)"value1"));
        Assert.assertThat((Object)parsed.getParameter("param2"), (Matcher)CoreMatchers.is((Object)"value2"));
        Assert.assertThat((Object)parsed.getParameter(""), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)parsed.toRfcString(), (Matcher)CoreMatchers.is((Object)"m/s; charset=UTF-8; param1=\"value1\"; param2=\"value2\""));
        Assert.assertThat((Object)parsed.isDefinedInApp(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void mimeTypeAndParamsParamsDefinedInApp() {
        MediaType parsed = MediaType.parseDefinedInApp((String)"m/s; param1=value1; param2=value2");
        Assert.assertThat((Object)parsed.getPrimaryType(), (Matcher)CoreMatchers.is((Object)"m"));
        Assert.assertThat((Object)parsed.getSubType(), (Matcher)CoreMatchers.is((Object)"s"));
        Assert.assertThat((Object)parsed.getCharset().isPresent(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)parsed.getParameter("param1"), (Matcher)CoreMatchers.is((Object)"value1"));
        Assert.assertThat((Object)parsed.getParameter("param2"), (Matcher)CoreMatchers.is((Object)"value2"));
        Assert.assertThat((Object)parsed.getParameter(""), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)parsed.toRfcString(), (Matcher)CoreMatchers.is((Object)"m/s; param1=\"value1\"; param2=\"value2\""));
        Assert.assertThat((Object)parsed.isDefinedInApp(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void onlyMimeTypeDefinedInApp() {
        MediaType parsed = MediaType.parseDefinedInApp((String)"m/s");
        Assert.assertThat((Object)parsed.getPrimaryType(), (Matcher)CoreMatchers.is((Object)"m"));
        Assert.assertThat((Object)parsed.getSubType(), (Matcher)CoreMatchers.is((Object)"s"));
        Assert.assertThat((Object)parsed.getCharset().isPresent(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)parsed.getParameter(""), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)parsed.toRfcString(), (Matcher)CoreMatchers.is((Object)"m/s"));
        Assert.assertThat((Object)parsed.isDefinedInApp(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void cachingCorrectly() {
        MediaType parsedAppDefined = MediaType.parseDefinedInApp((String)"test/foo;a=1");
        MediaType parsed = MediaType.parse((String)"test/foo;a=1");
        Assert.assertThat((Object)parsedAppDefined.isDefinedInApp(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)parsed, (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)parsedAppDefined)));
    }

    @Test
    public void shouldNotBeEqualParseAndParseDefined() {
        MediaType parsedAppDefined = MediaType.parseDefinedInApp((String)"test/foo");
        MediaType parse = MediaType.parse((String)"test/foo");
        Assert.assertThat((Object)parsedAppDefined, (Matcher)CoreMatchers.is((Object)parse));
        Assert.assertThat((Object)parsedAppDefined.hashCode(), (Matcher)CoreMatchers.is((Object)parse.hashCode()));
        parsedAppDefined = MediaType.parseDefinedInApp((String)"test/foo;a=1");
        parse = MediaType.parse((String)"test/foo;a=1");
        Assert.assertThat((Object)parsedAppDefined, (Matcher)Matchers.not((Matcher)CoreMatchers.is((Object)parse)));
        Assert.assertThat((Object)parsedAppDefined.hashCode(), (Matcher)Matchers.not((Matcher)CoreMatchers.is((Object)parse.hashCode())));
    }

    @Test
    public void paramWithSpecialChar() {
        MediaType parsed1 = MediaType.parse((String)"m/s; param1=\"@\"");
        Assert.assertThat((Object)parsed1.getParameter("param1"), (Matcher)CoreMatchers.is((Object)"@"));
        MediaType parsed2 = MediaType.parse((String)parsed1.toRfcString());
        Assert.assertThat((Object)parsed1, (Matcher)CoreMatchers.is((Object)parsed2));
    }

    @Test
    public void changeCharset() {
        MediaType parsed = MediaType.parse((String)"m/s");
        MediaType withCharset = parsed.withCharset(StandardCharsets.UTF_8);
        Assert.assertThat((Object)withCharset.getPrimaryType(), (Matcher)CoreMatchers.is((Object)"m"));
        Assert.assertThat((Object)withCharset.getSubType(), (Matcher)CoreMatchers.is((Object)"s"));
        Assert.assertThat(withCharset.getCharset().get(), (Matcher)CoreMatchers.is((Object)StandardCharsets.UTF_8));
        Assert.assertThat((Object)withCharset.getParameter("charset"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)withCharset.getParameter(""), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)withCharset.toRfcString(), (Matcher)CoreMatchers.is((Object)"m/s; charset=UTF-8"));
        Assert.assertThat((Object)parsed.matches(withCharset), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)parsed.equals((Object)withCharset), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void takeIntoAccountKnownParamName() {
        MediaType.setKnownParamNames(Arrays.asList("a", "b", "c"));
        try {
            MediaType parse = MediaType.parse((String)"test/foo;a=1");
            Assert.assertThat((Object)parse.isDefinedInApp(), (Matcher)CoreMatchers.is((Object)true));
            parse = MediaType.parse((String)"test/foo;a=1;c=1");
            Assert.assertThat((Object)parse.isDefinedInApp(), (Matcher)CoreMatchers.is((Object)true));
            parse = MediaType.parse((String)"test/foo");
            Assert.assertThat((Object)parse.isDefinedInApp(), (Matcher)CoreMatchers.is((Object)true));
            parse = MediaType.parse((String)"test/foo;charset=UTF-8; a=1");
            Assert.assertThat((Object)parse.isDefinedInApp(), (Matcher)CoreMatchers.is((Object)true));
            parse = MediaType.parse((String)"test/foo;charset=UTF-8");
            Assert.assertThat((Object)parse.isDefinedInApp(), (Matcher)CoreMatchers.is((Object)true));
            parse = MediaType.parse((String)"test/foo;a=1;b=2;c=1");
            Assert.assertThat((Object)parse.isDefinedInApp(), (Matcher)CoreMatchers.is((Object)true));
            parse = MediaType.parse((String)"test/foo;charset=UTF-8;d=2");
            Assert.assertThat((Object)parse.isDefinedInApp(), (Matcher)CoreMatchers.is((Object)false));
            parse = MediaType.parse((String)"test/foo;a=UTF-8;d=2");
            Assert.assertThat((Object)parse.isDefinedInApp(), (Matcher)CoreMatchers.is((Object)false));
            parse = MediaType.parse((String)"test/foo;d=2");
            Assert.assertThat((Object)parse.isDefinedInApp(), (Matcher)CoreMatchers.is((Object)false));
        }
        finally {
            MediaType.setKnownParamNames(Collections.emptyList());
        }
    }

    @Test
    public void removeCharset() {
        MediaType parsed = MediaType.parse((String)"m/s; charset=UTF-8");
        MediaType withoutCharset = parsed.withoutParameters();
        Assert.assertThat((Object)withoutCharset.getPrimaryType(), (Matcher)CoreMatchers.is((Object)"m"));
        Assert.assertThat((Object)withoutCharset.getSubType(), (Matcher)CoreMatchers.is((Object)"s"));
        Assert.assertThat((Object)withoutCharset.getCharset().isPresent(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)withoutCharset.getParameter("charset"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)withoutCharset.getParameter(""), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)withoutCharset.toRfcString(), (Matcher)CoreMatchers.is((Object)"m/s"));
        Assert.assertThat((Object)parsed.matches(withoutCharset), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)parsed.equals((Object)withoutCharset), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void removeParams() {
        MediaType parsed = MediaType.parse((String)"m/s; param1=value1; param2=value2");
        MediaType withoutParams = parsed.withoutParameters();
        Assert.assertThat((Object)withoutParams.getPrimaryType(), (Matcher)CoreMatchers.is((Object)"m"));
        Assert.assertThat((Object)withoutParams.getSubType(), (Matcher)CoreMatchers.is((Object)"s"));
        Assert.assertThat((Object)withoutParams.getCharset().isPresent(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)withoutParams.getParameter("charset"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)withoutParams.getParameter("param1"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)withoutParams.getParameter("param2"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)withoutParams.getParameter(""), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)withoutParams.toRfcString(), (Matcher)CoreMatchers.is((Object)"m/s"));
        Assert.assertThat((Object)parsed.matches(withoutParams), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)parsed.equals((Object)withoutParams), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void changeCharsetWithParams() {
        MediaType parsed = MediaType.parse((String)"m/s; param1=value1; param2=value2");
        MediaType withCharset = parsed.withCharset(StandardCharsets.UTF_8);
        Assert.assertThat((Object)withCharset.getPrimaryType(), (Matcher)CoreMatchers.is((Object)"m"));
        Assert.assertThat((Object)withCharset.getSubType(), (Matcher)CoreMatchers.is((Object)"s"));
        Assert.assertThat(withCharset.getCharset().get(), (Matcher)CoreMatchers.is((Object)StandardCharsets.UTF_8));
        Assert.assertThat((Object)withCharset.getParameter("charset"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)withCharset.getParameter("param1"), (Matcher)CoreMatchers.is((Object)"value1"));
        Assert.assertThat((Object)withCharset.getParameter("param2"), (Matcher)CoreMatchers.is((Object)"value2"));
        Assert.assertThat((Object)withCharset.getParameter(""), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)withCharset.toRfcString(), (Matcher)CoreMatchers.is((Object)"m/s; charset=UTF-8; param1=\"value1\"; param2=\"value2\""));
        Assert.assertThat((Object)parsed.matches(withCharset), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)parsed.equals((Object)withCharset), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void matchesMimeType() {
        MediaType parsed11 = MediaType.parse((String)"m1/s1");
        MediaType parsed12 = MediaType.parse((String)"m1/s2");
        MediaType parsed21 = MediaType.parse((String)"m2/s1");
        MediaType parsed22 = MediaType.parse((String)"m2/s2");
        Assert.assertThat((Object)parsed11.matches(MediaType.parse((String)parsed11.toRfcString())), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)parsed11.matches(MediaType.parse((String)parsed12.toRfcString())), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)parsed11.matches(MediaType.parse((String)parsed21.toRfcString())), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)parsed11.matches(MediaType.parse((String)parsed22.toRfcString())), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)parsed11.matches(MediaType.ANY), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)MediaType.ANY.matches(parsed11), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void invalidMimeType() {
        this.expected.expect(IllegalArgumentException.class);
        this.expected.expectMessage(CoreMatchers.containsString((String)"MediaType cannot be parsed"));
        this.expected.expectMessage(CoreMatchers.containsString((String)"invalid"));
        MediaType.parse((String)"invalid");
    }

    @Test
    public void invalidCharset() {
        this.expected.expect(UnsupportedCharsetException.class);
        this.expected.expectMessage(CoreMatchers.containsString((String)"invalid"));
        MediaType.parse((String)"m/s;charset=invalid");
    }

    @Test
    public void invalidCharsInParamsMimeType() {
        this.expected.expect(IllegalArgumentException.class);
        this.expected.expectMessage(CoreMatchers.containsString((String)"MediaType cannot be parsed"));
        this.expected.expectMessage(CoreMatchers.containsString((String)"m/s;param=@"));
        MediaType.parse((String)"m/s;param=@");
    }

    @Test
    public void serialize() throws IOException, ClassNotFoundException {
        MediaType parsed = MediaType.parse((String)"m/s");
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        new ObjectOutputStream(os).writeObject(parsed);
        Object deserialized = new ObjectInputStream(new ByteArrayInputStream(os.toByteArray())).readObject();
        Assert.assertThat((Object)deserialized, (Matcher)CoreMatchers.is((Object)parsed));
    }

    @Test
    public void serializeWithCharset() throws IOException, ClassNotFoundException {
        MediaType parsed = MediaType.parse((String)"m/s");
        MediaType withCharset = parsed.withCharset(StandardCharsets.UTF_8);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        new ObjectOutputStream(os).writeObject(withCharset);
        Object deserialized = new ObjectInputStream(new ByteArrayInputStream(os.toByteArray())).readObject();
        Assert.assertThat((Object)deserialized, (Matcher)CoreMatchers.is((Object)withCharset));
    }

    @Test
    public void parseAndGenerateMimeTypeCorrectly() {
        String originalMediaTypeString = "application/csv; quote=\"\\\"\"; separator=\"\\\\\"";
        MediaType mediaType = MediaType.parse((String)"application/csv; quote=\"\\\"\"; separator=\"\\\\\"");
        Assert.assertThat((Object)mediaType.getParameter("quote"), (Matcher)CoreMatchers.is((Object)"\""));
        Assert.assertThat((Object)mediaType.getParameter("separator"), (Matcher)CoreMatchers.is((Object)"\\"));
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("quote", mediaType.getParameter("quote"));
        properties.put("separator", mediaType.getParameter("separator"));
        MediaType newMediaType = MediaType.parse((String)"application/csv").withParamaters(properties);
        Assert.assertThat((Object)newMediaType.toRfcString(), (Matcher)CoreMatchers.is((Object)"application/csv; quote=\"\\\"\"; separator=\"\\\\\""));
    }

    @Test
    public void constantsAndParsedSameInstance() {
        MediaType appXml = MediaType.APPLICATION_XML;
        Assert.assertThat((Object)MediaType.parse((String)appXml.toRfcString()), (Matcher)Matchers.sameInstance((Object)appXml));
    }

    @Test
    public void sameParsedWithParamsNotSameInstance() {
        MediaType withParam1 = MediaType.parse((String)"multipart/lalala; boundary=\"---- next message ----\"");
        MediaType withParam2 = MediaType.parse((String)"multipart/lalala; boundary=\"---- next message ----\"");
        Assert.assertThat((Object)withParam1, (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)withParam2)));
    }

    @Test
    public void withoutParametersCached() {
        MediaType withParam = MediaType.parse((String)"multipart/lalala; boundary=\"---- next message ----\"");
        MediaType withoutParam = MediaType.parse((String)"multipart/lalala");
        Assert.assertThat((Object)withParam.withoutParameters(), (Matcher)Matchers.sameInstance((Object)withoutParam));
    }
}

