/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.functional;

import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.functional.Either;

public class EitherTestCase {
    @Test
    public void getValueLeftEither() {
        Assert.assertThat((Object)Either.left((Object)1).getValue(), (Matcher)Matchers.equalTo(Optional.of(1)));
    }

    @Test
    public void getValueRightEither() {
        Assert.assertThat((Object)Either.right((Object)2).getValue(), (Matcher)Matchers.equalTo(Optional.of(2)));
    }

    @Test
    public void getValueEmptyEither() {
        Assert.assertThat((Object)Either.empty().getValue(), (Matcher)Matchers.equalTo(Optional.empty()));
    }

    @Test
    public void getValueEmptyEitherBuiltLeft() {
        Assert.assertThat((Object)Either.left(null).getValue(), (Matcher)Matchers.equalTo(Optional.empty()));
    }

    @Test
    public void getValueEmptyEitherBuiltRight() {
        Assert.assertThat((Object)Either.right(null).getValue(), (Matcher)Matchers.equalTo(Optional.empty()));
    }

    @Test
    public void reduceLeftEither() {
        Assert.assertThat((Object)Either.left((Object)1).reduce(l -> "l", r -> "r"), (Matcher)Matchers.equalTo((Object)"l"));
    }

    @Test
    public void reduceRightEither() {
        Assert.assertThat((Object)Either.right((Object)2).reduce(l -> "l", r -> "r"), (Matcher)Matchers.equalTo((Object)"r"));
    }

    @Test
    public void reduceEmptyEither() {
        Assert.assertThat((Object)Either.empty().reduce(l -> "l", r -> "r"), (Matcher)Matchers.nullValue());
    }

    @Test
    public void reduceEmptyEitherBuiltLeft() {
        Assert.assertThat((Object)Either.left(null).reduce(l -> "l", r -> "r"), (Matcher)Matchers.nullValue());
    }

    @Test
    public void reduceEmptyEitherBuiltRight() {
        Assert.assertThat((Object)Either.right(null).reduce(l -> "l", r -> "r"), (Matcher)Matchers.nullValue());
    }

    @Test
    public void mapRightOnLeftDoesntCallMapper() {
        Either.left((Object)"").mapRight(r -> {
            Assert.fail((String)"Must not call mapper");
            return r;
        });
    }

    @Test
    public void mapLeftOnRightDoesntCallMapper() {
        Either.right((Object)"").mapLeft(l -> {
            Assert.fail((String)"Must not call mapper");
            return l;
        });
    }

    @Test
    public void applyRightOnLeftDoesntCallConsumer() {
        Either.left((Object)"").applyRight(r -> Assert.fail((String)"Must not call consumer"));
    }

    @Test
    public void applyLeftOnRightDoesntCallConsumer() {
        Either.right((Object)"").applyLeft(l -> Assert.fail((String)"Must not call consumer"));
    }

    @Test
    public void applyOnLeftDoesntCallRightConsumer() {
        Either.left((Object)"").apply(l -> {}, r -> Assert.fail((String)"Must not call right consumer"));
    }

    @Test
    public void applyOnRightDoesntCallLeftConsumer() {
        Either.right((Object)"").apply(l -> Assert.fail((String)"Must not call left consumer"), r -> {});
    }

    @Test
    public void reduceOnLeftDoesntCallRightFunction() {
        Either.left((Object)"", String.class).reduce(l -> l, r -> {
            Assert.fail((String)"Must not call right function");
            return r;
        });
    }

    @Test
    public void reduceOnRightDoesntCallLeftFunction() {
        Either.right(String.class, (Object)"").reduce(l -> {
            Assert.fail((String)"Must not call left function");
            return l;
        }, r -> r);
    }

    @Test
    public void leftToString() {
        Assert.assertThat((Object)Either.left((Object)"hello").toString(), (Matcher)Matchers.equalTo((Object)"Either - left: { hello }"));
    }

    @Test
    public void rightToString() {
        Assert.assertThat((Object)Either.right((Object)"world").toString(), (Matcher)Matchers.equalTo((Object)"Either - right: { world }"));
    }

    @Test
    public void emptyToString() {
        Assert.assertThat((Object)Either.empty().toString(), (Matcher)Matchers.equalTo((Object)"Either - empty"));
    }
}

