/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.deployment.meta;

import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.MulePluginModel;

public class MulePluginModelBuilderTestCase {
    private static final String ARTIFACT_NAME = "artifact-name";
    private static final String MULE_VERSION = "4.0.0";
    private static final String DESCRIBER_ID = "ID-1";
    private static final String BUNDLE_DESCRIPTOR_LOADER_ID = "descriptorLoaderId";
    private static final String CLASSLOADER_DESCRIPTOR_LOADER_ID = "classLoaderLoaderId";
    private MulePluginModel.MulePluginModelBuilder builder;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void before() {
        this.builder = new MulePluginModel.MulePluginModelBuilder();
    }

    @Test
    public void buildWithExtensionModelDescriptor() {
        ((MulePluginModel.MulePluginModelBuilder)this.builder.setName(ARTIFACT_NAME)).setMinMuleVersion(MULE_VERSION);
        this.builder.withExtensionModelDescriber().setId(DESCRIBER_ID);
        this.builder.withBundleDescriptorLoader(new MuleArtifactLoaderDescriptor(BUNDLE_DESCRIPTOR_LOADER_ID, Collections.emptyMap()));
        this.builder.withClassLoaderModelDescriptorLoader(new MuleArtifactLoaderDescriptor(CLASSLOADER_DESCRIPTOR_LOADER_ID, Collections.emptyMap()));
        MulePluginModel mulePluginModel = this.builder.build();
        Assert.assertThat((Object)mulePluginModel.getName(), (Matcher)CoreMatchers.is((Object)ARTIFACT_NAME));
        Assert.assertThat((Object)mulePluginModel.getMinMuleVersion(), (Matcher)CoreMatchers.is((Object)MULE_VERSION));
        Assert.assertThat((Object)mulePluginModel.getExtensionModelLoaderDescriptor().isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)((MuleArtifactLoaderDescriptor)mulePluginModel.getExtensionModelLoaderDescriptor().get()).getId(), (Matcher)CoreMatchers.is((Object)DESCRIBER_ID));
        Assert.assertThat((Object)((MuleArtifactLoaderDescriptor)mulePluginModel.getExtensionModelLoaderDescriptor().get()).getAttributes().size(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)mulePluginModel.getBundleDescriptorLoader().getId(), (Matcher)CoreMatchers.equalTo((Object)BUNDLE_DESCRIPTOR_LOADER_ID));
        Assert.assertThat((Object)mulePluginModel.getBundleDescriptorLoader().getAttributes(), (Matcher)CoreMatchers.is(Collections.emptyMap()));
        Assert.assertThat((Object)mulePluginModel.getClassLoaderModelLoaderDescriptor().getId(), (Matcher)CoreMatchers.equalTo((Object)CLASSLOADER_DESCRIPTOR_LOADER_ID));
        Assert.assertThat((Object)mulePluginModel.getClassLoaderModelLoaderDescriptor().getAttributes(), (Matcher)CoreMatchers.is(Collections.emptyMap()));
    }

    @Test
    public void buildWithoutExtensionModelDescriptor() {
        ((MulePluginModel.MulePluginModelBuilder)this.builder.setName(ARTIFACT_NAME)).setMinMuleVersion(MULE_VERSION);
        this.builder.withBundleDescriptorLoader(new MuleArtifactLoaderDescriptor(BUNDLE_DESCRIPTOR_LOADER_ID, Collections.emptyMap()));
        this.builder.withClassLoaderModelDescriptorLoader(new MuleArtifactLoaderDescriptor(CLASSLOADER_DESCRIPTOR_LOADER_ID, Collections.emptyMap()));
        MulePluginModel mulePluginModel = this.builder.build();
        Assert.assertThat((Object)mulePluginModel.getName(), (Matcher)CoreMatchers.is((Object)ARTIFACT_NAME));
        Assert.assertThat((Object)mulePluginModel.getMinMuleVersion(), (Matcher)CoreMatchers.is((Object)MULE_VERSION));
        Assert.assertThat((Object)mulePluginModel.getExtensionModelLoaderDescriptor().isPresent(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)mulePluginModel.getBundleDescriptorLoader().getId(), (Matcher)CoreMatchers.equalTo((Object)BUNDLE_DESCRIPTOR_LOADER_ID));
        Assert.assertThat((Object)mulePluginModel.getBundleDescriptorLoader().getAttributes(), (Matcher)CoreMatchers.is(Collections.emptyMap()));
        Assert.assertThat((Object)mulePluginModel.getClassLoaderModelLoaderDescriptor().getId(), (Matcher)CoreMatchers.equalTo((Object)CLASSLOADER_DESCRIPTOR_LOADER_ID));
        Assert.assertThat((Object)mulePluginModel.getClassLoaderModelLoaderDescriptor().getAttributes(), (Matcher)CoreMatchers.is(Collections.emptyMap()));
    }

    @Test
    public void buildWithoutBundleDescriptorLoader() {
        ((MulePluginModel.MulePluginModelBuilder)this.builder.setName(ARTIFACT_NAME)).setMinMuleVersion(MULE_VERSION);
        this.builder.withExtensionModelDescriber().setId(DESCRIBER_ID);
        this.expectedException.expect(IllegalArgumentException.class);
        this.builder.build();
    }

    @Test
    public void blankName() {
        this.builder.setName(null);
        this.expectedException.expect(IllegalArgumentException.class);
        this.builder.build();
    }

    @Test
    public void blankVersion() {
        this.builder.setMinMuleVersion(null);
        this.expectedException.expect(IllegalArgumentException.class);
        this.builder.build();
    }

    @Test
    public void blankExtensionModelDescriberId() {
        this.builder.withExtensionModelDescriber().setId(null);
        this.expectedException.expect(IllegalArgumentException.class);
        this.builder.build();
    }

    @Test
    public void blankExtensionModelDescriberAttribute() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.builder.withExtensionModelDescriber().setId("id").addProperty(null, (Object)"a value");
    }
}

