/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.privileged.exception;

import java.util.Objects;
import org.mule.runtime.api.exception.MuleException;

public class SuppressedMuleException
extends MuleException {
    private static final long serialVersionUID = -2810315886149183162L;
    private final MuleException suppressedException;

    protected SuppressedMuleException(Throwable throwable, MuleException causeToSuppress) {
        super(Objects.requireNonNull(throwable, "Exception cannot be null"));
        this.suppressedException = Objects.requireNonNull(causeToSuppress, "Cannot suppress a null cause");
        this.addSuppressionToMuleExceptionInfo(causeToSuppress);
    }

    private void addSuppressionToMuleExceptionInfo(MuleException causeToSuppress) {
        this.getExceptionInfo().addSuppressedCause(causeToSuppress);
        this.addAllInfo(causeToSuppress.getAdditionalInfo());
        Throwable nestedCause = causeToSuppress;
        while (nestedCause.getCause() != null && nestedCause.getCause() != nestedCause) {
            if (!((nestedCause = nestedCause.getCause()) instanceof MuleException)) continue;
            this.addAllInfo(((MuleException)nestedCause).getAdditionalInfo());
            if (!(nestedCause instanceof SuppressedMuleException)) continue;
            this.getExceptionInfo().addSuppressedCause(((SuppressedMuleException)nestedCause).getSuppressedException());
        }
    }

    public Throwable unwrap() {
        return this.getCause();
    }

    public MuleException getSuppressedException() {
        return this.suppressedException;
    }

    public static Throwable suppressIfPresent(Throwable exception, Class<? extends MuleException> causeToSuppress) {
        for (Throwable cause = exception; cause != null && !(cause instanceof SuppressedMuleException); cause = cause.getCause()) {
            if (causeToSuppress.isInstance(cause)) {
                return new SuppressedMuleException(exception, (MuleException)cause);
            }
            if (cause.getCause() == cause) break;
        }
        return exception;
    }

    @Override
    public String getVerboseMessage() {
        return "Suppressed: " + super.getSummaryMessage();
    }

    @Override
    public String getSummaryMessage() {
        return "Suppressed: " + super.getSummaryMessage();
    }
}

