/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api;

import io.qameta.allure.Issue;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.runtime.api.meta.MuleVersion;

public class MuleVersionTestCase {
    @Test
    public void testValidMuleVersions() {
        MatcherAssert.assertThat((Object)"3.3.1", (Matcher)Matchers.is((Object)new MuleVersion("3.3.1").toString()));
        MatcherAssert.assertThat((Object)"3.4", (Matcher)Matchers.is((Object)new MuleVersion("3.4").toString()));
        MatcherAssert.assertThat((Object)"3.4-RC1", (Matcher)Matchers.is((Object)new MuleVersion("3.4-RC1").toString()));
        MatcherAssert.assertThat((Object)"3.4.1-SNAPSHOT", (Matcher)Matchers.is((Object)new MuleVersion("3.4.1-SNAPSHOT").toString()));
        MatcherAssert.assertThat((Object)"3.4-M3-SNAPSHOT", (Matcher)Matchers.is((Object)new MuleVersion("3.4-M3-SNAPSHOT").toString()));
        MatcherAssert.assertThat((Object)"4.0.1+20130313144700", (Matcher)Matchers.is((Object)new MuleVersion("4.0.1+20130313144700").toString()));
        MatcherAssert.assertThat((Object)"4.2.1-prerelease+meta", (Matcher)Matchers.is((Object)new MuleVersion("4.2.1-prerelease+meta").toString()));
        MatcherAssert.assertThat((Object)"4.9.5----RC-SNAPSHOT.12.9.1--.12+788", (Matcher)Matchers.is((Object)new MuleVersion("4.9.5----RC-SNAPSHOT.12.9.1--.12+788").toString()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidMuleVersion1() {
        new MuleVersion("a.b.c");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidMuleVersion2() {
        new MuleVersion("1.1.SNAPSHOT");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidMuleVersion3() {
        new MuleVersion("1");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidMuleVersion4() {
        new MuleVersion("1-RC1");
    }

    @Test
    public void testEquals() {
        MatcherAssert.assertThat((Object)new MuleVersion("3.3.3"), (Matcher)Matchers.is((Object)new MuleVersion("3.3.3")));
        MatcherAssert.assertThat((Object)new MuleVersion("3.4"), (Matcher)Matchers.is((Object)new MuleVersion("3.4")));
        MatcherAssert.assertThat((Object)new MuleVersion("3.4-RC1"), (Matcher)Matchers.is((Object)new MuleVersion("3.4-RC1")));
    }

    @Test
    public void testAtLeast() {
        MatcherAssert.assertThat((Object)new MuleVersion("3.4.1").atLeast("3.4"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)new MuleVersion("3.4.1").atLeast("3.4.1"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)new MuleVersion("3.4.1").atLeast("3.3.2"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)new MuleVersion("3.4.1").atLeast("3.4.1-RC2"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)new MuleVersion("3.4.1-RC1").atLeast("3.4.1"), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testAtLeastBase() {
        MatcherAssert.assertThat((Object)new MuleVersion("3.4.1").atLeastBase("3.4"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)new MuleVersion("3.4.1-SNAPSHOT").atLeastBase("3.4"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)new MuleVersion("3.3.0").atLeastBase("3.3"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)new MuleVersion("3.4.0-RC1").atLeastBase("3.4"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)new MuleVersion("3.5.0-M1-SNAPSHOT").atLeastBase("3.5.0"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)new MuleVersion("3.4.1-RC1").atLeastBase("3.5"), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testNewerThan() {
        MatcherAssert.assertThat((Object)new MuleVersion("3.4.1").newerThan("3.4"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)new MuleVersion("3.4.1").newerThan("3.3.2"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)new MuleVersion("3.4.1").newerThan("3.4.1-RC2"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)new MuleVersion("3.5.0-BIGHORN").newerThan("3.5.0-ANDES"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)new MuleVersion("3.4.1").newerThan("3.4.1"), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)new MuleVersion("3.5.0-ANDES").newerThan("3.5.0-ANDES"), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testPriorTo() {
        MatcherAssert.assertThat((Object)new MuleVersion("3.4").priorTo("3.4.1"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)new MuleVersion("3.3.2").priorTo("3.4.1"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)new MuleVersion("3.4.1-RC2").priorTo("3.4.1"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)new MuleVersion("3.5.0-ANDES").priorTo("3.5.0-BIGHORN"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)new MuleVersion("3.4.1").priorTo("3.4.1"), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)new MuleVersion("3.5.0-ANDES").priorTo("3.5.0-ANDES"), (Matcher)Matchers.is((Object)false));
    }

    @Test
    @Issue(value="MULE-19682")
    public void testWithoutSuffixes() {
        MatcherAssert.assertThat((Object)"3.3.1", (Matcher)Matchers.is((Object)new MuleVersion("3.3.1").withoutSuffixes().toString()));
        MatcherAssert.assertThat((Object)"3.4.0", (Matcher)Matchers.is((Object)new MuleVersion("3.4").withoutSuffixes().toString()));
        MatcherAssert.assertThat((Object)"3.4.0", (Matcher)Matchers.is((Object)new MuleVersion("3.4-RC1").withoutSuffixes().toString()));
        MatcherAssert.assertThat((Object)"3.4.1", (Matcher)Matchers.is((Object)new MuleVersion("3.4.1-SNAPSHOT").withoutSuffixes().toString()));
        MatcherAssert.assertThat((Object)"3.4.0", (Matcher)Matchers.is((Object)new MuleVersion("3.4-M3-SNAPSHOT").withoutSuffixes().toString()));
        MatcherAssert.assertThat((Object)"4.0.1", (Matcher)Matchers.is((Object)new MuleVersion("4.0.1").withoutSuffixes().toString()));
        MatcherAssert.assertThat((Object)"4.2.1", (Matcher)Matchers.is((Object)new MuleVersion("4.2.1-prerelease+meta").withoutSuffixes().toString()));
        MatcherAssert.assertThat((Object)"4.9.5", (Matcher)Matchers.is((Object)new MuleVersion("4.9.5----RC-SNAPSHOT.12.9.1--.12+788").withoutSuffixes().toString()));
    }
}

