/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.deployment.persistence;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsEmptyCollection;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.runtime.api.deployment.meta.MuleDeployableModel;
import org.mule.runtime.api.deployment.meta.MuleServerPluginModel;
import org.mule.runtime.api.deployment.meta.MuleServiceModel;
import org.mule.runtime.api.deployment.meta.Product;
import org.mule.runtime.api.deployment.persistence.AbstractMuleArtifactModelJsonSerializer;
import org.mule.runtime.api.deployment.persistence.MuleApplicationModelJsonSerializer;
import org.mule.runtime.api.deployment.persistence.MuleDomainModelJsonSerializer;
import org.mule.runtime.api.deployment.persistence.MuleServerPluginModelJsonSerializer;
import org.mule.runtime.api.deployment.persistence.MuleServiceModelJsonSerializer;

@RunWith(value=Parameterized.class)
public class MuleArtifactModelJsonSerializerTestCase {
    private static final String DESCRIPTOR_NAME = "descriptor";
    private static final JsonObject VALID_JSON = new JsonObject();
    private static final JsonParser parser = new JsonParser();
    private static JsonObject json;
    private final AbstractMuleArtifactModelJsonSerializer<MuleDeployableModel> serializer;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @BeforeClass
    public static void setUp() {
        VALID_JSON.addProperty("name", "someName");
        VALID_JSON.addProperty("requiredProduct", Product.MULE.toString());
        VALID_JSON.addProperty("minMuleVersion", "someVersion");
        JsonObject id = new JsonObject();
        id.addProperty("id", "someId");
        VALID_JSON.add("classLoaderModelLoaderDescriptor", (JsonElement)id);
        VALID_JSON.add("bundleDescriptorLoader", (JsonElement)id);
    }

    @Before
    public void resetJson() {
        json = parser.parse(VALID_JSON.toString()).getAsJsonObject();
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({new MuleApplicationModelJsonSerializer()}, {new MuleDomainModelJsonSerializer()});
    }

    public MuleArtifactModelJsonSerializerTestCase(AbstractMuleArtifactModelJsonSerializer serializer) {
        this.serializer = serializer;
    }

    @Test
    public void redeploymentEnabledDefaultIfNotPresentIsTrue() {
        MuleDeployableModel muleArtifactModel = (MuleDeployableModel)this.serializer.deserialize("{}");
        Assert.assertThat((Object)muleArtifactModel.isRedeploymentEnabled(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void configsAttributeIsNullIfNotPresent() throws Exception {
        MuleDeployableModel muleArtifactModel = (MuleDeployableModel)this.serializer.deserialize("{}");
        Assert.assertThat((Object)muleArtifactModel.getConfigs(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void configsAttributeIsEmptyIfEmptyInSerialization() throws Exception {
        MuleDeployableModel muleArtifactModel = (MuleDeployableModel)this.serializer.deserialize("{'configs':[]}");
        Assert.assertThat((Object)muleArtifactModel.getConfigs(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)muleArtifactModel.getConfigs(), (Matcher)Is.is((Matcher)IsEmptyCollection.empty()));
    }

    @Test
    public void mandatoryFieldsCheckIsTrueIfAllPresent() throws Exception {
        MuleDeployableModel muleArtifactModel = (MuleDeployableModel)this.serializer.deserialize(json.toString());
        muleArtifactModel.validateModel(DESCRIPTOR_NAME);
    }

    @Test
    public void securePropertiesDeserialization() {
        MuleDeployableModel muleArtifactModel = (MuleDeployableModel)this.serializer.deserialize("{\"secureProperties\": [\"db.username\", \"db.password\"]}");
        List secretProperties = muleArtifactModel.getSecureProperties();
        Assert.assertThat((Object)secretProperties, (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)secretProperties, (Matcher)Matchers.contains((Object[])new String[]{"db.username", "db.password"}));
    }

    @Test
    public void mandatoryFieldsCheckIsFalseIfNameNotSet() throws Exception {
        json.remove("name");
        MuleDeployableModel muleArtifactModel = (MuleDeployableModel)this.serializer.deserialize(json.toString());
        this.expectedException.expect(IllegalStateException.class);
        muleArtifactModel.validateModel(DESCRIPTOR_NAME);
    }

    @Test
    public void mandatoryFieldsCheckIsFalseIfMinMuleVersionNotSet() throws Exception {
        json.remove("minMuleVersion");
        MuleDeployableModel muleArtifactModel = (MuleDeployableModel)this.serializer.deserialize(json.toString());
        this.expectedException.expect(IllegalStateException.class);
        muleArtifactModel.validateModel(DESCRIPTOR_NAME);
    }

    @Test
    public void mandatoryFieldsCheckIsFalseIfClassLoaderModelLoaderDescriptorNotSet() throws Exception {
        json.remove("classLoaderModelLoaderDescriptor");
        MuleDeployableModel muleArtifactModel = (MuleDeployableModel)this.serializer.deserialize(json.toString());
        this.expectedException.expect(IllegalStateException.class);
        muleArtifactModel.validateModel(DESCRIPTOR_NAME);
    }

    @Test
    public void mandatoryFieldsCheckIsFalseIfBundleDescriptorLoaderNotSet() throws Exception {
        json.remove("bundleDescriptorLoader");
        MuleDeployableModel muleArtifactModel = (MuleDeployableModel)this.serializer.deserialize(json.toString());
        this.expectedException.expect(IllegalStateException.class);
        muleArtifactModel.validateModel(DESCRIPTOR_NAME);
    }

    @Test
    public void mandatoryFieldsCheckIsFalseIfClassLoaderModelLoaderDescriptorWithNoId() throws Exception {
        json.remove("classLoaderModelLoaderDescriptor");
        json.add("classLoaderModelLoaderDescriptor", (JsonElement)new JsonObject());
        MuleDeployableModel muleArtifactModel = (MuleDeployableModel)this.serializer.deserialize(json.toString());
        this.expectedException.expect(IllegalStateException.class);
        muleArtifactModel.validateModel(DESCRIPTOR_NAME);
    }

    @Test
    public void mandatoryFieldsCheckIsFalseIfBundleDescriptorWithNoId() throws Exception {
        json.remove("bundleDescriptorLoader");
        json.add("bundleDescriptorLoader", (JsonElement)new JsonObject());
        MuleDeployableModel muleArtifactModel = (MuleDeployableModel)this.serializer.deserialize(json.toString());
        this.expectedException.expect(IllegalStateException.class);
        muleArtifactModel.validateModel(DESCRIPTOR_NAME);
    }

    @Test
    public void validateServerPluginModelMandatoryFields() throws Exception {
        MuleServerPluginModelJsonSerializer serializer = new MuleServerPluginModelJsonSerializer();
        MuleServerPluginModel muleServerPluginModel = (MuleServerPluginModel)serializer.deserialize(json.toString());
        try {
            muleServerPluginModel.validateModel(DESCRIPTOR_NAME);
            Assert.fail((String)"Descriptor validation should have failed because of missing pluginClassName");
        }
        catch (Exception exception) {
            // empty catch block
        }
        json.addProperty("pluginClassName", "somePluginClassName");
        muleServerPluginModel = (MuleServerPluginModel)serializer.deserialize(json.toString());
        muleServerPluginModel.validateModel(DESCRIPTOR_NAME);
    }

    @Test
    public void validateServiceModelMandatoryFields() throws Exception {
        MuleServiceModelJsonSerializer serializer = new MuleServiceModelJsonSerializer();
        MuleServiceModel muleServiceModel = (MuleServiceModel)serializer.deserialize(json.toString());
        try {
            muleServiceModel.validateModel(DESCRIPTOR_NAME);
            Assert.fail((String)"Descriptor validation should have failed because of missing contract");
        }
        catch (Exception exception) {
            // empty catch block
        }
        JsonObject contract = new JsonObject();
        JsonArray contracts = new JsonArray();
        contracts.add((JsonElement)contract);
        json.add("contracts", (JsonElement)contracts);
        muleServiceModel = (MuleServiceModel)serializer.deserialize(json.toString());
        try {
            muleServiceModel.validateModel(DESCRIPTOR_NAME);
            Assert.fail((String)"Descriptor validation should have failed because of contract missing properties");
        }
        catch (Exception exception) {
            // empty catch block
        }
        contract.addProperty("serviceProviderClassName", "FooProvider");
        muleServiceModel = (MuleServiceModel)serializer.deserialize(json.toString());
        try {
            muleServiceModel.validateModel(DESCRIPTOR_NAME);
            Assert.fail((String)"Descriptor validation should still have failed because of contract missing properties");
        }
        catch (Exception exception) {
            // empty catch block
        }
        contract.addProperty("contractClassName", "FooService");
        muleServiceModel = (MuleServiceModel)serializer.deserialize(json.toString());
        muleServiceModel.validateModel(DESCRIPTOR_NAME);
    }
}

