/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.component.execution;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.component.execution.CompletableCallback;
import org.mule.runtime.api.util.Reference;

public class CompletableCallbackTestCase {
    private Reference<Integer> completeReference = new Reference();
    private Reference<Throwable> errorReference = new Reference();
    private int executionIndex = 0;
    private CompletableCallback<Integer> callback = new CompletableCallback<Integer>(){

        public void complete(Integer value) {
            CompletableCallbackTestCase.this.completeReference.set((Object)(value + CompletableCallbackTestCase.this.executionIndex++));
        }

        public void error(Throwable e) {
            CompletableCallbackTestCase.this.errorReference.set((Object)e);
        }
    };

    @Test
    public void andThen() {
        final Reference enrichedValue = new Reference();
        final Reference enrichedError = new Reference();
        CompletableCallback andThen = this.callback.andThen((CompletableCallback)new CompletableCallback<Integer>(){

            public void complete(Integer value) {
                enrichedValue.set((Object)(value + CompletableCallbackTestCase.this.executionIndex++));
            }

            public void error(Throwable e) {
                enrichedError.set((Object)new RuntimeException(e));
            }
        });
        andThen.complete((Object)0);
        Assert.assertThat((Object)this.completeReference.get(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)enrichedValue.get(), (Matcher)CoreMatchers.is((Object)1));
        Exception e = new Exception();
        andThen.error((Throwable)e);
        Assert.assertThat((Object)this.errorReference.get(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)e)));
        Assert.assertThat((Object)enrichedError.get(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(RuntimeException.class)));
        Assert.assertThat((Object)((Throwable)enrichedError.get()).getCause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)e)));
    }

    @Test
    public void andThenConsume() {
        Reference enrichedValue = new Reference();
        CompletableCallback andThen = this.callback.andThen(v -> {
            Integer cfr_ignored_0 = (Integer)enrichedValue.set((Object)(v + this.executionIndex++));
        });
        andThen.complete((Object)0);
        Assert.assertThat((Object)this.completeReference.get(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)enrichedValue.get(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void before() {
        final Reference enrichedValue = new Reference();
        final Reference enrichedError = new Reference();
        CompletableCallback before = this.callback.before((CompletableCallback)new CompletableCallback<Integer>(){

            public void complete(Integer value) {
                enrichedValue.set((Object)(value + CompletableCallbackTestCase.this.executionIndex++));
            }

            public void error(Throwable e) {
                enrichedError.set((Object)new RuntimeException(e));
            }
        });
        before.complete((Object)0);
        Assert.assertThat((Object)this.completeReference.get(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)enrichedValue.get(), (Matcher)CoreMatchers.is((Object)0));
        Exception e = new Exception();
        before.error((Throwable)e);
        Assert.assertThat((Object)this.errorReference.get(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)e)));
        Assert.assertThat((Object)enrichedError.get(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(RuntimeException.class)));
        Assert.assertThat((Object)((Throwable)enrichedError.get()).getCause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)e)));
    }

    @Test
    public void beforeConsume() {
        Reference enrichedValue = new Reference();
        CompletableCallback before = this.callback.before(value -> {
            Integer cfr_ignored_0 = (Integer)enrichedValue.set((Object)(value + this.executionIndex++));
        });
        before.complete((Object)0);
        Assert.assertThat((Object)this.completeReference.get(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)enrichedValue.get(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void always() {
        CompletableCallback always = CompletableCallback.always(() -> ++this.executionIndex);
        always.complete((Object)0);
        Assert.assertThat((Object)this.executionIndex, (Matcher)CoreMatchers.is((Object)1));
        always.error((Throwable)new Exception());
        Assert.assertThat((Object)this.executionIndex, (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void finallyBefore() {
        CompletableCallback finallyBefore = this.callback.finallyBefore(() -> ++this.executionIndex);
        finallyBefore.complete((Object)0);
        Assert.assertThat((Object)this.completeReference.get(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)this.executionIndex, (Matcher)CoreMatchers.is((Object)2));
        Exception e = new Exception();
        finallyBefore.error((Throwable)e);
        Assert.assertThat((Object)this.errorReference.get(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)e)));
        Assert.assertThat((Object)this.executionIndex, (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void finallyAfter() {
        CompletableCallback finallyAfter = this.callback.finallyAfter(() -> ++this.executionIndex);
        finallyAfter.complete((Object)0);
        Assert.assertThat((Object)this.completeReference.get(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)this.executionIndex, (Matcher)CoreMatchers.is((Object)2));
        Exception e = new Exception();
        finallyAfter.error((Throwable)e);
        Assert.assertThat((Object)this.errorReference.get(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)e)));
        Assert.assertThat((Object)this.executionIndex, (Matcher)CoreMatchers.is((Object)3));
    }
}

