/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.test.metadata;

import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsEmptyCollection;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.MetadataProperty;

public class MetadataKeyBuilderTestCase {
    private static final String ID = "id";
    private static final String DESCRIPTION = "description";
    private static final String CHILD = "Child";

    @Test
    public void createMetadataKey() {
        TestMetadataProperty testMetadataProperty = new TestMetadataProperty();
        MetadataKey key = MetadataKeyBuilder.newKey((String)ID).withDisplayName(DESCRIPTION).withProperty((MetadataProperty)testMetadataProperty).build();
        MatcherAssert.assertThat((Object)key.getId(), (Matcher)Is.is((Object)ID));
        MatcherAssert.assertThat((Object)key.getDisplayName(), (Matcher)Is.is((Object)DESCRIPTION));
        MatcherAssert.assertThat((Object)key.getMetadataProperty(TestMetadataProperty.class).isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((TestMetadataProperty)key.getMetadataProperty(TestMetadataProperty.class).get()), (Matcher)Is.is((Object)testMetadataProperty));
        MatcherAssert.assertThat((Object)key.getMetadataProperty(InvalidMetadataProperty.class), (Matcher)Is.is(Optional.empty()));
        MatcherAssert.assertThat((Object)key.getProperties(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)key.getProperties(), (Matcher)Matchers.contains((Object[])new MetadataProperty[]{testMetadataProperty}));
    }

    @Test
    public void createMetadataKeyWithDefaults() {
        MetadataKey key = MetadataKeyBuilder.newKey((String)ID).build();
        MatcherAssert.assertThat((Object)key.getId(), (Matcher)Is.is((Object)ID));
        MatcherAssert.assertThat((Object)key.getDisplayName(), (Matcher)Is.is((Object)ID));
        MatcherAssert.assertThat((Object)key.getProperties(), (Matcher)Is.is((Matcher)IsEmptyCollection.empty()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void addMetadataPropertiesOfTheSameType() {
        MetadataKeyBuilder.newKey((String)ID).withDisplayName(DESCRIPTION).withProperty((MetadataProperty)new TestMetadataProperty()).withProperty((MetadataProperty)new TestMetadataProperty()).build();
    }

    @Test
    public void createMultilevelMetadataKey() {
        MetadataKeyBuilder childKey = MetadataKeyBuilder.newKey((String)CHILD).withDisplayName(CHILD);
        MetadataKeyBuilder childKey2 = MetadataKeyBuilder.newKey((String)"Child2");
        MetadataKey key = MetadataKeyBuilder.newKey((String)ID).withDisplayName(DESCRIPTION).withProperty((MetadataProperty)new TestMetadataProperty()).withChild(childKey).withChild(childKey2).build();
        MatcherAssert.assertThat((Object)key.getId(), (Matcher)Is.is((Object)ID));
        MatcherAssert.assertThat((Object)key.getDisplayName(), (Matcher)Is.is((Object)DESCRIPTION));
        MatcherAssert.assertThat((Object)key.getProperties(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)key.getChilds(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)key.getChilds(), (Matcher)Matchers.hasItems((Object[])new MetadataKey[]{childKey.build(), childKey2.build()}));
    }

    private class InvalidMetadataProperty
    implements MetadataProperty {
        private InvalidMetadataProperty() {
        }

        public String getName() {
            return "Invalid";
        }
    }

    private class TestMetadataProperty
    implements MetadataProperty {
        private TestMetadataProperty() {
        }

        public String getName() {
            return "TestMetadataProperty";
        }
    }
}

