/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.runtime.api.connectivity;

import org.mule.api.annotation.NoImplement;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.ObjectNotFoundException;

/**
 * Service for doing connectivity testing.
 *
 * A {@code ConnectivityTestingService}
 *
 * @since 4.0
 */
@NoImplement
public interface ConnectivityTestingService {

  /**
   * Key under which the {@link ConnectivityTestingService} can be found in the {@link org.mule.runtime.api.artifact.Registry}
   */
  String CONNECTIVITY_TESTING_SERVICE_KEY = "_muleConnectivityTestingService";

  /**
   * Does connection testing over the component registered under the provider identifier
   *
   * @param location component identifier over the one connectivity testing is done.
   * @return connectivity testing result.
   * @throws UnsupportedConnectivityTestingObjectException when it's not possible to do connectivity testing over the mule
   *                                                       component.
   * @throws {@link                                        ObjectNotFoundException} when the object to use to do connectivity does
   *                                                       not exists
   */
  ConnectionValidationResult testConnection(Location location);

}
