/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.test.message.error.matcher;

import java.util.ArrayList;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.error.matcher.DisjunctiveErrorTypeMatcher;
import org.mule.runtime.api.message.error.matcher.SingleErrorTypeMatcher;
import org.mule.runtime.api.message.error.matcher.WildcardErrorTypeMatcher;

public class ErrorMatchersTestCase {
    private ErrorType dummyParent = new ErrorType(){

        public String getIdentifier() {
            return "PARENT";
        }

        public String getNamespace() {
            return "TST";
        }

        public ErrorType getParentErrorType() {
            return null;
        }
    };
    private ErrorType dummyErrorType = new ErrorType(){
        private static final long serialVersionUID = -5155728711167777541L;

        public String getIdentifier() {
            return "TEST_ERROR";
        }

        public String getNamespace() {
            return "TST";
        }

        public ErrorType getParentErrorType() {
            return ErrorMatchersTestCase.this.dummyParent;
        }
    };
    private ErrorType unrelatedError = new ErrorType(){

        public String getIdentifier() {
            return "TEST_ERROR";
        }

        public String getNamespace() {
            return "OTHERNAMESPACE";
        }

        public ErrorType getParentErrorType() {
            return null;
        }
    };

    @Test
    public void singleErrorTypeForSpecificError() {
        SingleErrorTypeMatcher matcher = new SingleErrorTypeMatcher(this.dummyParent);
        MatcherAssert.assertThat((Object)matcher.match(this.dummyParent), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)matcher.match(this.dummyErrorType), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)matcher.match(this.unrelatedError), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void combinedErrorTypes() {
        ArrayList<SingleErrorTypeMatcher> matchers = new ArrayList<SingleErrorTypeMatcher>();
        matchers.add(new SingleErrorTypeMatcher(this.dummyErrorType));
        matchers.add(new SingleErrorTypeMatcher(this.unrelatedError));
        DisjunctiveErrorTypeMatcher matcher = new DisjunctiveErrorTypeMatcher(matchers);
        MatcherAssert.assertThat((Object)matcher.match(this.dummyParent), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)matcher.match(this.dummyErrorType), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)matcher.match(this.unrelatedError), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void wildcardInNameMatcher() {
        WildcardErrorTypeMatcher matcher = new WildcardErrorTypeMatcher(new ComponentIdentifier(){

            public String getNamespace() {
                return "TST";
            }

            public String getNamespaceUri() {
                return null;
            }

            public String getName() {
                return "*";
            }
        });
        MatcherAssert.assertThat((Object)matcher.match(this.dummyParent), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)matcher.match(this.dummyErrorType), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)matcher.match(this.unrelatedError), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void wildcardInNamespaceMatcher() {
        WildcardErrorTypeMatcher matcher = new WildcardErrorTypeMatcher(new ComponentIdentifier(){

            public String getNamespace() {
                return "*";
            }

            public String getNamespaceUri() {
                return null;
            }

            public String getName() {
                return "TEST_ERROR";
            }
        });
        MatcherAssert.assertThat((Object)matcher.match(this.dummyParent), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)matcher.match(this.dummyErrorType), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)matcher.match(this.unrelatedError), (Matcher)CoreMatchers.is((Object)true));
    }
}

