/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.test.component;

import io.qameta.allure.Issue;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.DefaultComponentIdentifier;

public class DefaultComponentIdentifierTestCase {
    @Test
    @Issue(value="W-16237424")
    public void testBuilderWithValidParametersWithLeadingWhiteSpace() {
        String namespace = " namespace";
        String name = " name";
        ComponentIdentifier componentIdentifier = DefaultComponentIdentifier.builder().namespace(namespace).name(name).build();
        MatcherAssert.assertThat((Object)componentIdentifier.getName(), (Matcher)Is.is((Object)"name"));
        MatcherAssert.assertThat((Object)componentIdentifier.getNamespace(), (Matcher)Is.is((Object)"namespace"));
    }

    @Test
    @Issue(value="W-16237424")
    public void testBuilderWithValidParametersWithTrailingWhiteSpace() {
        String namespace = "namespace   ";
        String name = "name    ";
        ComponentIdentifier componentIdentifier = DefaultComponentIdentifier.builder().namespace(namespace).name(name).build();
        MatcherAssert.assertThat((Object)componentIdentifier.getName(), (Matcher)Is.is((Object)"name"));
        MatcherAssert.assertThat((Object)componentIdentifier.getNamespace(), (Matcher)Is.is((Object)"namespace"));
    }
}

