/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.test.alerts;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsEmptyIterable;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.alert.TimedDataAggregation;
import org.mule.runtime.api.alert.TimedDataBuffer;
import org.mule.runtime.api.time.TimeSupplier;

public class TimedDataBufferTestCase {
    private MutableTimeSupplier mutableTimeSupplier;
    private TimedDataBuffer<String> timedDataBuffer;

    @Before
    public void setUp() {
        this.mutableTimeSupplier = new MutableTimeSupplier();
        this.mutableTimeSupplier.setCurrentTimeMillis(0L);
        this.timedDataBuffer = new TimedDataBuffer((TimeSupplier)this.mutableTimeSupplier);
    }

    @Test
    public void aggregationOnEmpty() {
        TimedDataAggregation aggregation = this.timedDataBuffer.aggregate((Object)"base", (a, t) -> {
            Assert.fail((String)"Aggregation function called for no items");
            return a;
        });
        MatcherAssert.assertThat((Object)aggregation.forLast1MinInterval(), (Matcher)Is.is((Object)"base"));
        MatcherAssert.assertThat((Object)aggregation.forLast5MinsInterval(), (Matcher)Is.is((Object)"base"));
        MatcherAssert.assertThat((Object)aggregation.forLast15MinsInterval(), (Matcher)Is.is((Object)"base"));
        MatcherAssert.assertThat((Object)aggregation.forLast60MinsInterval(), (Matcher)Is.is((Object)"base"));
    }

    @Test
    public void oneEntryEachInterval() {
        this.timedDataBuffer.put((Object)"a");
        this.mutableTimeSupplier.setCurrentTimeMillis(TimeUnit.MINUTES.toMillis(2L));
        this.timedDataBuffer.put((Object)"b");
        this.mutableTimeSupplier.setCurrentTimeMillis(TimeUnit.MINUTES.toMillis(6L));
        this.timedDataBuffer.put((Object)"c");
        TimedDataAggregation aggregation = this.timedDataBuffer.aggregate(Collections.emptyList(), (a, t) -> {
            ArrayList<String> partialAggregation = new ArrayList<String>();
            partialAggregation.addAll((Collection<String>)a);
            partialAggregation.add((String)t);
            return partialAggregation;
        });
        MatcherAssert.assertThat((Object)((List)aggregation.forLast1MinInterval()), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"c"}));
        MatcherAssert.assertThat((Object)((List)aggregation.forLast5MinsInterval()), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"b", "c"}));
        MatcherAssert.assertThat((Object)((List)aggregation.forLast15MinsInterval()), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"a", "b", "c"}));
        MatcherAssert.assertThat((Object)((List)aggregation.forLast60MinsInterval()), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"a", "b", "c"}));
    }

    @Test
    public void cleanOnPut() {
        this.timedDataBuffer.put((Object)"a");
        this.mutableTimeSupplier.setCurrentTimeMillis(TimeUnit.MINUTES.toMillis(61L));
        this.timedDataBuffer.put((Object)"c");
        TimedDataAggregation aggregation = this.timedDataBuffer.aggregate(Collections.emptyList(), (a, t) -> {
            ArrayList<String> partialAggregation = new ArrayList<String>();
            partialAggregation.addAll((Collection<String>)a);
            partialAggregation.add((String)t);
            return partialAggregation;
        });
        MatcherAssert.assertThat((Object)((List)aggregation.forLast1MinInterval()), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"c"}));
        MatcherAssert.assertThat((Object)((List)aggregation.forLast5MinsInterval()), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"c"}));
        MatcherAssert.assertThat((Object)((List)aggregation.forLast15MinsInterval()), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"c"}));
        MatcherAssert.assertThat((Object)((List)aggregation.forLast60MinsInterval()), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"c"}));
    }

    @Test
    public void cleanOnAggregate() {
        this.timedDataBuffer.put((Object)"a");
        this.mutableTimeSupplier.setCurrentTimeMillis(TimeUnit.MINUTES.toMillis(61L));
        TimedDataAggregation aggregation = this.timedDataBuffer.aggregate(Collections.emptyList(), (a, t) -> {
            ArrayList<String> partialAggregation = new ArrayList<String>();
            partialAggregation.addAll((Collection<String>)a);
            partialAggregation.add((String)t);
            return partialAggregation;
        });
        MatcherAssert.assertThat((Object)((List)aggregation.forLast1MinInterval()), (Matcher)IsEmptyIterable.emptyIterable());
        MatcherAssert.assertThat((Object)((List)aggregation.forLast5MinsInterval()), (Matcher)IsEmptyIterable.emptyIterable());
        MatcherAssert.assertThat((Object)((List)aggregation.forLast15MinsInterval()), (Matcher)IsEmptyIterable.emptyIterable());
        MatcherAssert.assertThat((Object)((List)aggregation.forLast60MinsInterval()), (Matcher)IsEmptyIterable.emptyIterable());
    }

    @Test
    public void cleanOnSize() {
        this.timedDataBuffer.put((Object)"a");
        this.mutableTimeSupplier.setCurrentTimeMillis(TimeUnit.MINUTES.toMillis(50L));
        this.timedDataBuffer.put((Object)"c");
        MatcherAssert.assertThat((Object)this.timedDataBuffer.size(), (Matcher)Is.is((Object)2));
        this.mutableTimeSupplier.setCurrentTimeMillis(TimeUnit.MINUTES.toMillis(70L));
        MatcherAssert.assertThat((Object)this.timedDataBuffer.size(), (Matcher)Is.is((Object)1));
    }

    private static class MutableTimeSupplier
    implements TimeSupplier {
        private long currentTimeMillis;

        private MutableTimeSupplier() {
        }

        public Long get() {
            return this.currentTimeMillis;
        }

        public long getAsLong() {
            return this.currentTimeMillis;
        }

        public Instant getAsInstant() {
            return Instant.ofEpochMilli(this.currentTimeMillis);
        }

        public void setCurrentTimeMillis(long currentTimeMillis) {
            this.currentTimeMillis = currentTimeMillis;
        }
    }
}

