/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.test.internal.exception;

import io.qameta.allure.Issue;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsMapContaining;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.privileged.exception.SuppressedMuleException;

@RunWith(value=Parameterized.class)
public class SuppressedMuleExceptionTestCase {
    private final boolean isVerboseExceptions;
    private boolean wasVerboseExceptions;

    @Parameterized.Parameters(name="Verbose exceptions: {0}")
    public static List<Object[]> parameters() {
        return Arrays.asList({true}, {false});
    }

    public SuppressedMuleExceptionTestCase(boolean isVerboseExceptions) {
        this.isVerboseExceptions = isVerboseExceptions;
    }

    @Before
    public void setUp() throws Exception {
        this.wasVerboseExceptions = Boolean.parseBoolean(System.clearProperty("mule.verbose.exceptions"));
        System.setProperty("mule.verbose.exceptions", Boolean.toString(this.isVerboseExceptions));
        MuleException.refreshVerboseExceptions();
    }

    @After
    public void tearDown() throws Exception {
        System.setProperty("mule.verbose.exceptions", Boolean.toString(this.wasVerboseExceptions));
    }

    @Test
    @Issue(value="MULE-18041")
    public void whenClassToSuppressIsNotFoundThenNoSuppressionIsAdded() {
        Throwable result = SuppressedMuleException.suppressIfPresent((Throwable)((Object)new SimpleException(I18nMessageFactory.createStaticMessage((String)"Test"))), ExceptionWithAdditionalInfo.class);
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Matcher)CoreMatchers.instanceOf(SimpleException.class)));
    }

    @Test
    @Issue(value="MULE-18041")
    public void whenClassToSuppressIsFoundThenSuppressionIsAdded() {
        Throwable result = SuppressedMuleException.suppressIfPresent((Throwable)((Object)new SimpleException((Throwable)((Object)new ExceptionWithAdditionalInfo()))), ExceptionWithAdditionalInfo.class);
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Matcher)CoreMatchers.instanceOf(SuppressedMuleException.class)));
    }

    @Test
    @Issue(value="MULE-18041")
    public void whenSuppressionIsAddedThenIncludeSuppressedAdditionalProperties() {
        Throwable suppressedTestException = SuppressedMuleException.suppressIfPresent((Throwable)((Object)new SimpleException((Throwable)((Object)new ExceptionWithAdditionalInfo()))), SimpleException.class);
        Map suppressedTestExceptionEntries = ((SuppressedMuleException)suppressedTestException).getInfo();
        Throwable suppressedAnotherTestException = SuppressedMuleException.suppressIfPresent((Throwable)((Object)new SimpleException((Throwable)((Object)new ExceptionWithAdditionalInfo()))), ExceptionWithAdditionalInfo.class);
        Map suppressedAnotherTestExceptionEntries = ((SuppressedMuleException)suppressedAnotherTestException).getInfo();
        MatcherAssert.assertThat((Object)suppressedTestExceptionEntries, (Matcher)IsMapContaining.hasEntry((Object)"Additional entry key", (Object)"Test additional entry value"));
        MatcherAssert.assertThat((Object)suppressedAnotherTestExceptionEntries, (Matcher)IsMapContaining.hasEntry((Object)"Additional entry key", (Object)"Test additional entry value"));
    }

    @Test
    @Issue(value="MULE-18041")
    public void whenSuppressionIsAddedThenPreviousSuppressionsAreAdded() {
        Throwable suppressedTestException = SuppressedMuleException.suppressIfPresent((Throwable)((Object)new SimpleException(I18nMessageFactory.createStaticMessage((String)"Test"))), SimpleException.class);
        Throwable suppressedAnotherTestException = SuppressedMuleException.suppressIfPresent((Throwable)((Object)new ExceptionWithAdditionalInfo(suppressedTestException)), ExceptionWithAdditionalInfo.class);
        List suppressions = ((MuleException)suppressedAnotherTestException).getExceptionInfo().getSuppressedCauses();
        MatcherAssert.assertThat((Object)suppressions, (Matcher)Matchers.contains((Matcher[])new Matcher[]{CoreMatchers.sameInstance((Object)((SuppressedMuleException)suppressedAnotherTestException).getSuppressedException()), CoreMatchers.sameInstance((Object)((SuppressedMuleException)suppressedTestException).getSuppressedException())}));
    }

    @Test
    public void selfCausedExceptionInMainLoopMustBeResolved() {
        Throwable suppressedSelfCausedException = SuppressedMuleException.suppressIfPresent((Throwable)((Object)new SimpleException((Throwable)((Object)new SelfCausedException()))), SelfCausedException.class);
        MatcherAssert.assertThat((Object)suppressedSelfCausedException, (Matcher)Is.is((Matcher)CoreMatchers.instanceOf(SuppressedMuleException.class)));
        List suppressions = ((MuleException)suppressedSelfCausedException).getExceptionInfo().getSuppressedCauses();
        MatcherAssert.assertThat((Object)suppressions, (Matcher)Matchers.contains((Matcher)CoreMatchers.sameInstance((Object)((SuppressedMuleException)suppressedSelfCausedException).getSuppressedException())));
    }

    @Test
    public void selfCausedExceptionInSecondaryLoopMustBeResolved() {
        Throwable suppressedSelfCausedException = SuppressedMuleException.suppressIfPresent((Throwable)((Object)new SimpleException((Throwable)((Object)new SelfCausedException()))), SimpleException.class);
        MatcherAssert.assertThat((Object)suppressedSelfCausedException, (Matcher)Is.is((Matcher)CoreMatchers.instanceOf(SuppressedMuleException.class)));
        List suppressions = ((MuleException)suppressedSelfCausedException).getExceptionInfo().getSuppressedCauses();
        MatcherAssert.assertThat((Object)suppressions, (Matcher)Matchers.contains((Matcher)CoreMatchers.sameInstance((Object)((SuppressedMuleException)suppressedSelfCausedException).getSuppressedException())));
    }

    @Test
    @Issue(value="MULE-18562")
    public void consecutiveSuppressionsMustNotBePossible() {
        SimpleException exception = new SimpleException((Throwable)((Object)new ExceptionWithAdditionalInfo()));
        SuppressedMuleException suppression = (SuppressedMuleException)SuppressedMuleException.suppressIfPresent((Throwable)((Object)exception), ExceptionWithAdditionalInfo.class);
        SuppressedMuleException attemptedConsecutiveSuppression = (SuppressedMuleException)SuppressedMuleException.suppressIfPresent((Throwable)suppression, SimpleException.class);
        MatcherAssert.assertThat((Object)attemptedConsecutiveSuppression, (Matcher)Is.is((Object)suppression));
    }

    @Test
    @Issue(value="MULE-18562")
    public void suppressionMustBeUnwrapped() {
        SimpleException unwrappedException = new SimpleException();
        SuppressedMuleException result = (SuppressedMuleException)SuppressedMuleException.suppressIfPresent((Throwable)((Object)unwrappedException), SimpleException.class);
        MatcherAssert.assertThat((Object)result.unwrap(), (Matcher)Is.is((Object)((Object)unwrappedException)));
    }

    @Test
    @Issue(value="W-15643200")
    public void suppressionMustHaveItsOwnDetailedMessage() {
        SimpleException unwrappedException = new SimpleException(I18nMessageFactory.createStaticMessage((String)"Test"));
        SuppressedMuleException result = (SuppressedMuleException)SuppressedMuleException.suppressIfPresent((Throwable)((Object)new SimpleException(I18nMessageFactory.createStaticMessage((String)"Test"))), SimpleException.class);
        MatcherAssert.assertThat((Object)result.getDetailedMessage(), (Matcher)CoreMatchers.equalTo((Object)("Suppressed: " + unwrappedException.getMessage())));
    }

    private static class SimpleException
    extends MuleException {
        private static final long serialVersionUID = 21078091124109763L;

        public SimpleException(I18nMessage test) {
            super(test);
        }

        public SimpleException(Throwable cause) {
            super(cause);
        }

        public SimpleException() {
        }
    }

    private static class ExceptionWithAdditionalInfo
    extends MuleException {
        private static final long serialVersionUID = -2095590887184779909L;

        public ExceptionWithAdditionalInfo() {
            this.getExceptionInfo().putAdditionalEntry("Additional entry key", (Object)"Test additional entry value");
        }

        public ExceptionWithAdditionalInfo(Throwable cause) {
            super(cause);
            this.getExceptionInfo().putAdditionalEntry("Additional entry key", (Object)"Test additional entry value");
        }
    }

    private static class SelfCausedException
    extends MuleException {
        private static final long serialVersionUID = -8420615463020752243L;

        private SelfCausedException() {
        }

        public synchronized Throwable getCause() {
            return this;
        }
    }
}

