/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.test.persistence;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptorBuilder;
import org.mule.runtime.api.deployment.meta.MulePluginModel;
import org.mule.runtime.api.deployment.persistence.MulePluginModelJsonSerializer;
import org.mule.runtime.api.test.persistence.AbstractMuleArtifactModelJsonSerializerTestCase;

public class MulePluginModelJsonSerializerTestCase
extends AbstractMuleArtifactModelJsonSerializerTestCase {
    private MulePluginModelJsonSerializer mulePluginModelJsonSerializer;

    @Before
    public void setUp() {
        this.mulePluginModelJsonSerializer = new MulePluginModelJsonSerializer();
    }

    @Test
    public void serialize() throws IOException {
        String describerName = "plugin-name";
        String describerMinMuleVersion = "4.2.3";
        String describerExtensionModelId = "annotations";
        String classAttributeKey = "class";
        String classAttributeValue = "org.mule.extension.internal.ExtensionConnector";
        String describerClassLoaderModelId = "annotations";
        String exportedPackagesKey = "exportedPackages";
        List<String> exportedPackagesAttributeValue = Arrays.asList("org.mule.extension.api", "org.mule.extension.api.exception");
        HashMap<String, String> bundleDescriptorAttributes = new HashMap<String, String>();
        bundleDescriptorAttributes.put("bundleDescriptorLoaderKey1", "bundleDescriptorLoaderValue1");
        bundleDescriptorAttributes.put("bundleDescriptorLoaderKey2", "bundleDescriptorLoaderValue2");
        MulePluginModel.MulePluginModelBuilder mulePluginModelBuilder = (MulePluginModel.MulePluginModelBuilder)((MulePluginModel.MulePluginModelBuilder)((MulePluginModel.MulePluginModelBuilder)new MulePluginModel.MulePluginModelBuilder().setName("plugin-name")).setMinMuleVersion("4.2.3")).withBundleDescriptorLoader(new MuleArtifactLoaderDescriptor("bundleDescriptorLoaderId", bundleDescriptorAttributes));
        mulePluginModelBuilder.withExtensionModelDescriber().setId("annotations").addProperty("class", (Object)"org.mule.extension.internal.ExtensionConnector");
        mulePluginModelBuilder.withClassLoaderModelDescriptorLoader(new MuleArtifactLoaderDescriptorBuilder().setId("annotations").addProperty("exportedPackages", exportedPackagesAttributeValue).build());
        String actual = this.mulePluginModelJsonSerializer.serialize((AbstractMuleArtifactModel)mulePluginModelBuilder.build());
        JsonObject actualElement = new JsonParser().parse(actual).getAsJsonObject();
        MatcherAssert.assertThat((Object)actualElement.get("name").getAsString(), (Matcher)Is.is((Object)"plugin-name"));
        MatcherAssert.assertThat((Object)actualElement.get("minMuleVersion").getAsString(), (Matcher)Is.is((Object)"4.2.3"));
        JsonObject extensionModelDescriptor = actualElement.get("extensionModelLoaderDescriptor").getAsJsonObject();
        MatcherAssert.assertThat((Object)extensionModelDescriptor.get("id").getAsString(), (Matcher)Is.is((Object)"annotations"));
        MatcherAssert.assertThat((Object)extensionModelDescriptor.get("attributes").getAsJsonObject().get("class").getAsString(), (Matcher)Is.is((Object)"org.mule.extension.internal.ExtensionConnector"));
        JsonObject classLoaderModelDescriptor = actualElement.get("classLoaderModelLoaderDescriptor").getAsJsonObject();
        MatcherAssert.assertThat((Object)classLoaderModelDescriptor.get("id").getAsString(), (Matcher)Is.is((Object)"annotations"));
        JsonArray attributes = classLoaderModelDescriptor.get("attributes").getAsJsonObject().get("exportedPackages").getAsJsonArray();
        MatcherAssert.assertThat((Object)attributes.size(), (Matcher)Is.is((Object)exportedPackagesAttributeValue.size()));
        ArrayList list = new ArrayList();
        attributes.iterator().forEachRemaining(jsonElement -> list.add(jsonElement.getAsString()));
        MatcherAssert.assertThat(list, (Matcher)Matchers.containsInAnyOrder((Object[])exportedPackagesAttributeValue.toArray()));
        JsonObject bundleDescriptor = actualElement.get("bundleDescriptorLoader").getAsJsonObject();
        MatcherAssert.assertThat((Object)bundleDescriptor.get("id").getAsString(), (Matcher)Is.is((Object)"bundleDescriptorLoaderId"));
        MatcherAssert.assertThat((Object)bundleDescriptor.get("attributes").getAsJsonObject().entrySet().size(), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)bundleDescriptor.get("attributes").getAsJsonObject().get("bundleDescriptorLoaderKey1").getAsString(), (Matcher)Matchers.equalTo((Object)"bundleDescriptorLoaderValue1"));
        MatcherAssert.assertThat((Object)bundleDescriptor.get("attributes").getAsJsonObject().get("bundleDescriptorLoaderKey2").getAsString(), (Matcher)Matchers.equalTo((Object)"bundleDescriptorLoaderValue2"));
    }

    @Test
    public void deserializeWithExtensionModel() throws IOException {
        InputStream resource = this.getClass().getResourceAsStream("/descriptor/plugin-descriptor-with-ext-model.json");
        MulePluginModel deserialized = (MulePluginModel)this.mulePluginModelJsonSerializer.deserialize(IOUtils.toString((InputStream)resource));
        this.assertNameAndMinMuleVersion(deserialized);
        this.assertBundleDescriptorLoader(deserialized.getBundleDescriptorLoader());
        this.assertExtensionModel(deserialized);
    }

    @Test
    public void deserializeWithClassLoaderModel() throws IOException {
        InputStream resource = this.getClass().getResourceAsStream("/descriptor/plugin-descriptor-with-classloader-model.json");
        MulePluginModel deserialized = (MulePluginModel)this.mulePluginModelJsonSerializer.deserialize(IOUtils.toString((InputStream)resource));
        this.assertNameAndMinMuleVersion(deserialized);
        this.assertBundleDescriptorLoader(deserialized.getBundleDescriptorLoader());
        MatcherAssert.assertThat((Object)deserialized.getExtensionModelLoaderDescriptor().isPresent(), (Matcher)Is.is((Object)false));
        this.assertClassLoaderModel(deserialized);
    }

    @Test
    public void deserializeWithExtensionModelAndClassLoaderModel() throws IOException {
        InputStream resource = this.getClass().getResourceAsStream("/descriptor/plugin-descriptor-with-ext-model-and-classloader-model.json");
        MulePluginModel deserialized = (MulePluginModel)this.mulePluginModelJsonSerializer.deserialize(IOUtils.toString((InputStream)resource));
        this.assertNameAndMinMuleVersion(deserialized);
        this.assertBundleDescriptorLoader(deserialized.getBundleDescriptorLoader());
        this.assertExtensionModel(deserialized);
        this.assertClassLoaderModel(deserialized);
    }

    @Test
    public void deserializeWithoutExtensionModel() throws IOException {
        InputStream resource = this.getClass().getResourceAsStream("/descriptor/plugin-descriptor-clean.json");
        MulePluginModel deserialized = (MulePluginModel)this.mulePluginModelJsonSerializer.deserialize(IOUtils.toString((InputStream)resource));
        this.assertNameAndMinMuleVersion(deserialized);
        this.assertBundleDescriptorLoader(deserialized.getBundleDescriptorLoader());
        MatcherAssert.assertThat((Object)deserialized.getExtensionModelLoaderDescriptor().isPresent(), (Matcher)Is.is((Object)false));
    }

    private void assertNameAndMinMuleVersion(MulePluginModel deserialize) {
        MatcherAssert.assertThat((Object)deserialize.getName(), (Matcher)Is.is((Object)"plugin-name"));
        MatcherAssert.assertThat((Object)deserialize.getMinMuleVersion(), (Matcher)Is.is((Object)"4.2.3"));
    }

    private void assertExtensionModel(MulePluginModel deserialize) {
        MatcherAssert.assertThat((Object)deserialize.getExtensionModelLoaderDescriptor().isPresent(), (Matcher)Is.is((Object)true));
        MuleArtifactLoaderDescriptor extensionModelDescriptor = (MuleArtifactLoaderDescriptor)deserialize.getExtensionModelLoaderDescriptor().get();
        MatcherAssert.assertThat((Object)extensionModelDescriptor.getId(), (Matcher)Is.is((Object)"annotations"));
        MatcherAssert.assertThat((Object)extensionModelDescriptor.getAttributes().size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat(extensionModelDescriptor.getAttributes().get("class"), (Matcher)Is.is((Object)"org.mule.extension.internal.ExtensionConnector"));
    }

    private void assertClassLoaderModel(MulePluginModel deserialize) {
        MuleArtifactLoaderDescriptor extensionModelDescriptor = deserialize.getClassLoaderModelLoaderDescriptor();
        MatcherAssert.assertThat((Object)extensionModelDescriptor.getId(), (Matcher)Is.is((Object)"maven"));
        MatcherAssert.assertThat((Object)extensionModelDescriptor.getAttributes().size(), (Matcher)Is.is((Object)2));
        Object exportedPackages = extensionModelDescriptor.getAttributes().get("exportedPackages");
        MatcherAssert.assertThat(exportedPackages, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(List.class)));
        MatcherAssert.assertThat((Object)((List)exportedPackages), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"org.mule.extension.api", "org.mule.extension.api.exception"}));
        Object exportedResources = extensionModelDescriptor.getAttributes().get("exportedResources");
        MatcherAssert.assertThat(exportedResources, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(List.class)));
        MatcherAssert.assertThat((Object)((List)exportedResources), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"/META-INF/some.file", "/META-INF/other.file"}));
    }
}

