/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.test.store;

import io.qameta.allure.Issue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreToMapAdapter;
import org.mule.runtime.api.store.SimpleMemoryObjectStore;

public class ObjectStoreToMapAdapterTestCase {
    private Map<String, Serializable> map;

    @Before
    public void setup() {
        this.map = new SimpleMemoryObjectStoreAsMap();
    }

    @Test
    public void isEmptyForNewMap() {
        MatcherAssert.assertThat((Object)this.map.isEmpty(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void addMakesIsEmptyFalse() {
        this.map.put("Hello", Integer.valueOf(5));
        MatcherAssert.assertThat((Object)this.map.isEmpty(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void sizeForNewMap() {
        MatcherAssert.assertThat((Object)this.map.size(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void sizeIncrementsWhenAddingElements() {
        this.map.put("Hello", Integer.valueOf(5));
        MatcherAssert.assertThat((Object)this.map.size(), (Matcher)Matchers.is((Object)1));
        this.map.put("Goodbye", Integer.valueOf(5));
        MatcherAssert.assertThat((Object)this.map.size(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void getReturnsCorrectValue() {
        this.map.put("Hello", Integer.valueOf(5));
        this.map.put("Goodbye", Integer.valueOf(6));
        MatcherAssert.assertThat((Object)this.map.get("Hello"), (Matcher)Matchers.is((Object)5));
        MatcherAssert.assertThat((Object)this.map.get("Goodbye"), (Matcher)Matchers.is((Object)6));
    }

    @Test
    public void returnNullIfKeyDoesNotExist() {
        MatcherAssert.assertThat((Object)this.map.get("Hello"), (Matcher)Matchers.nullValue());
    }

    @Test
    public void replacesValueWithSameKey() {
        this.map.put("Hello", (Serializable)((Object)"old"));
        this.map.put("Hello", (Serializable)((Object)"new"));
        MatcherAssert.assertThat((Object)this.map.get("Hello"), (Matcher)Matchers.is((Object)"new"));
        MatcherAssert.assertThat((Object)this.map.size(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void doesNotOverwriteSeperateKeysWithSameHash() {
        this.map.put("Ea", Integer.valueOf(5));
        this.map.put("FB", Integer.valueOf(6));
        MatcherAssert.assertThat((Object)this.map.get("Ea"), (Matcher)Matchers.is((Object)5));
        MatcherAssert.assertThat((Object)this.map.get("FB"), (Matcher)Matchers.is((Object)6));
    }

    @Test
    public void removeUnexistentKeyDoesNotThrowExceptionAndReturnsNull() {
        MatcherAssert.assertThat((Object)this.map.remove("Hello"), (Matcher)Matchers.nullValue());
    }

    @Test
    public void removeDecrementsSize() {
        this.map.put("Hello", Integer.valueOf(5));
        this.map.put("Goodbye", Integer.valueOf(6));
        MatcherAssert.assertThat((Object)this.map.size(), (Matcher)Matchers.is((Object)2));
        this.map.remove("Hello");
        MatcherAssert.assertThat((Object)this.map.size(), (Matcher)Matchers.is((Object)1));
        this.map.remove("Goodbye");
        MatcherAssert.assertThat((Object)this.map.size(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void removeDeletesElement() {
        this.map.put("Hello", Integer.valueOf(5));
        this.map.remove("Hello");
        MatcherAssert.assertThat((Object)this.map.get("Hello"), (Matcher)Matchers.nullValue());
    }

    @Test
    public void containsKeyForNewMap() {
        MatcherAssert.assertThat((Object)this.map.containsKey("Hello"), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void containsKeyForNonExistingKey() {
        this.map.put("Hello", Integer.valueOf(5));
        MatcherAssert.assertThat((Object)this.map.containsKey("Goodbye"), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void containsKeyForExistingKey() {
        this.map.put("Hello", Integer.valueOf(5));
        MatcherAssert.assertThat((Object)this.map.containsKey("Hello"), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void containsKeyForKeyWithEquivalentHash() {
        this.map.put("Ea", Integer.valueOf(5));
        MatcherAssert.assertThat((Object)this.map.containsKey("FB"), (Matcher)Matchers.is((Object)false));
    }

    @Test
    @Issue(value="MULE-18172")
    public void getDoesntThrowExceptionsWhenKeyIsUpdatedConcurrently() throws InterruptedException {
        Thread putThread;
        int i;
        int putThreadsCount = 100;
        int getThreadsCount = 100;
        int threadsSum = putThreadsCount + getThreadsCount;
        CountDownLatch threadsStartedLatch = new CountDownLatch(threadsSum);
        Semaphore startProcessingSemaphore = new Semaphore(0);
        AtomicInteger numberOfExceptions = new AtomicInteger(0);
        ArrayList<Thread> runningThreads = new ArrayList<Thread>();
        for (i = 0; i < putThreadsCount; ++i) {
            putThread = new Thread(() -> {
                try {
                    threadsStartedLatch.countDown();
                    startProcessingSemaphore.acquire();
                    this.map.put("Hello", Integer.valueOf(5));
                }
                catch (Exception e) {
                    numberOfExceptions.incrementAndGet();
                }
            });
            putThread.start();
            runningThreads.add(putThread);
        }
        for (i = 0; i < getThreadsCount; ++i) {
            putThread = new Thread(() -> {
                try {
                    threadsStartedLatch.countDown();
                    startProcessingSemaphore.acquire();
                    this.map.get("Hello");
                }
                catch (Exception e) {
                    numberOfExceptions.incrementAndGet();
                }
            });
            putThread.start();
            runningThreads.add(putThread);
        }
        threadsStartedLatch.await();
        startProcessingSemaphore.release(threadsSum);
        for (Thread thread : runningThreads) {
            thread.join();
        }
        MatcherAssert.assertThat((Object)numberOfExceptions.get(), (Matcher)Matchers.is((Object)0));
    }

    private static class SimpleMemoryObjectStoreAsMap<T extends Serializable>
    extends ObjectStoreToMapAdapter<T> {
        private final SimpleMemoryObjectStore<T> objectStore = new SimpleMemoryObjectStore();

        private SimpleMemoryObjectStoreAsMap() {
        }

        public ObjectStore<T> getObjectStore() {
            return this.objectStore;
        }
    }
}

