/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.test.util;

import java.nio.charset.Charset;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.internal.util.StringByteSizeCalculator;

public class StringByteSizeCalculatorTestCase {
    private static final String JAPANESE_MESSAGE = "\u3042 \u3047";
    private StringByteSizeCalculator calculator = new StringByteSizeCalculator();

    @Test
    public void matchesGetBytesDefaultCharset() {
        this.compare("test", Charset.defaultCharset());
    }

    @Test
    public void matchesGetBytesCustomCharset() {
        this.compare(JAPANESE_MESSAGE, Charset.forName("EUC-JP"));
    }

    private void compare(String payload, Charset charset) {
        Assert.assertThat((Object)this.calculator.count(payload, charset), (Matcher)Matchers.equalTo((Object)payload.getBytes(charset).length));
    }
}

