/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.internal;

import static java.util.Arrays.asList;

import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;

import java.util.Collection;
import java.util.Spliterator;
import java.util.stream.Stream;


public class TestArtifactAst implements ArtifactAst {

  private final Collection<ComponentAst> topLevelComponents;

  public TestArtifactAst(ComponentAst... topLevelComponents) {
    this.topLevelComponents = asList(topLevelComponents);
  }

  @Override
  public Stream<ComponentAst> recursiveStream() {
    topLevelComponents.stream()
        .flatMap(cm -> cm.recursiveStream());

    return topLevelComponents.stream()
        .flatMap(cm -> cm.recursiveStream());
  }

  @Override
  public Spliterator<ComponentAst> recursiveSpliterator() {
    return recursiveStream().spliterator();
  }

  @Override
  public Stream<ComponentAst> topLevelComponentsStream() {
    return topLevelComponents.stream();
  }

  @Override
  public Spliterator<ComponentAst> topLevelComponentsSpliterator() {
    return topLevelComponents.spliterator();
  }

}
