/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal;

import com.google.common.collect.Streams;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Spliterator;
import java.util.stream.Stream;
import org.mockito.Mockito;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentGenerationInformation;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.ParameterResolutionException;
import org.mule.runtime.ast.api.util.AstTraversalDirection;
import org.mule.runtime.ast.api.util.BaseComponentAst;
import org.mule.runtime.ast.internal.DefaultComponentGenerationInformation;

public class TestComponentAst
extends BaseComponentAst {
    private final Object model;
    private final List<ComponentAst> innerComponents;
    private Map<String, String> rawParams = Collections.emptyMap();
    private Map<String, ComponentAst> complexParams = Collections.emptyMap();

    public TestComponentAst(ComponentAst ... innerComponents) {
        this.model = null;
        this.innerComponents = Arrays.asList(innerComponents);
    }

    public TestComponentAst(Object model, ComponentAst ... innerComponents) {
        this.model = model;
        this.innerComponents = Arrays.asList(innerComponents);
    }

    public ComponentIdentifier getIdentifier() {
        return null;
    }

    public TypedComponentIdentifier.ComponentType getComponentType() {
        return null;
    }

    public ComponentLocation getLocation() {
        return null;
    }

    public Map<String, Object> getAnnotations() {
        return Collections.emptyMap();
    }

    public ComponentMetadataAst getMetadata() {
        return null;
    }

    public Optional<String> getComponentId() {
        return Optional.of(this.rawParams.get("name"));
    }

    public ExtensionModel getExtensionModel() {
        return (ExtensionModel)Mockito.mock(ExtensionModel.class);
    }

    public <M> Optional<M> getModel(Class<M> modelClass) {
        if (this.model == null || !modelClass.isAssignableFrom(this.model.getClass())) {
            return Optional.empty();
        }
        return Optional.of(this.model);
    }

    public MetadataType getType() {
        return null;
    }

    public ComponentGenerationInformation getGenerationInformation() {
        return DefaultComponentGenerationInformation.builder().build();
    }

    public ComponentParameterAst getParameter(String groupName, final String paramName) {
        final Optional paramModel = this.getModel(ParameterizedModel.class).flatMap(parameterized -> parameterized.getParameterGroupModels().stream().flatMap(g -> g.getParameterModels().stream()).filter(pm -> pm.getName().equals(paramName)).findAny());
        final ParameterGroupModel groupModel = (ParameterGroupModel)Mockito.mock(ParameterGroupModel.class);
        Mockito.when((Object)groupModel.getName()).thenReturn((Object)groupName);
        if (this.rawParams.containsKey(paramName) || paramModel.isPresent()) {
            return new ComponentParameterAst(){

                public Either<String, Object> getValue() {
                    return Either.right((Object)(this.getRawValue() != null ? this.getRawValue() : this.getModel().getDefaultValue()));
                }

                public <T> Either<String, Either<ParameterResolutionException, T>> getValueOrResolutionError() {
                    try {
                        return this.getValue().mapRight(fixedValue -> Either.right((Object)fixedValue));
                    }
                    catch (ParameterResolutionException e) {
                        return Either.right((Object)Either.left((Object)((Object)e)));
                    }
                }

                public String getResolvedRawValue() {
                    return (String)TestComponentAst.this.rawParams.get(paramName);
                }

                public String getRawValue() {
                    return (String)TestComponentAst.this.rawParams.get(paramName);
                }

                public ParameterModel getModel() {
                    return paramModel.orElse(null);
                }

                public ParameterGroupModel getGroupModel() {
                    return groupModel;
                }

                public Optional<ComponentMetadataAst> getMetadata() {
                    return Optional.empty();
                }

                public ComponentGenerationInformation getGenerationInformation() {
                    return DefaultComponentGenerationInformation.EMPTY_GENERATION_INFO;
                }

                public boolean isDefaultValue() {
                    return !Optional.ofNullable(this.getRawValue()).isPresent();
                }
            };
        }
        if (this.complexParams.containsKey(paramName)) {
            return new ComponentParameterAst(){

                public Either<String, Object> getValue() {
                    return Either.right(TestComponentAst.this.complexParams.get(paramName));
                }

                public <T> Either<String, Either<ParameterResolutionException, T>> getValueOrResolutionError() {
                    try {
                        return this.getValue().mapRight(fixedValue -> Either.right((Object)fixedValue));
                    }
                    catch (ParameterResolutionException e) {
                        return Either.right((Object)Either.left((Object)((Object)e)));
                    }
                }

                public String getResolvedRawValue() {
                    return null;
                }

                public String getRawValue() {
                    return null;
                }

                public ParameterModel getModel() {
                    return paramModel.orElse(null);
                }

                public ParameterGroupModel getGroupModel() {
                    return groupModel;
                }

                public Optional<ComponentMetadataAst> getMetadata() {
                    return Optional.empty();
                }

                public ComponentGenerationInformation getGenerationInformation() {
                    return DefaultComponentGenerationInformation.EMPTY_GENERATION_INFO;
                }

                public boolean isDefaultValue() {
                    return false;
                }
            };
        }
        throw new NoSuchElementException(paramName);
    }

    public Collection<ComponentParameterAst> getParameters() {
        return Collections.emptyList();
    }

    public void setParameters(Map<String, String> rawParams) {
        this.rawParams = rawParams;
    }

    public void setComplexParameters(Map<String, ComponentAst> complexParams) {
        this.complexParams = complexParams;
    }

    public Stream<ComponentAst> recursiveStream(AstTraversalDirection direction) {
        return Streams.concat((Stream[])new Stream[]{Collections.singleton(this).stream(), this.innerComponents.stream().flatMap(cm -> cm.recursiveStream(direction))});
    }

    public Spliterator<ComponentAst> recursiveSpliterator(AstTraversalDirection direction) {
        return this.recursiveStream(direction).spliterator();
    }

    public List<ComponentAst> directChildren() {
        return this.innerComponents;
    }

    public String toString() {
        return this.getComponentId().orElse(super.toString());
    }
}

