/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.jgrapht.traverse.TopologicalOrderIterator;
import org.junit.Test;
import org.mule.runtime.ast.graph.internal.cycle.GraphCycleRemover;

public class CycleRemoverTestCase {
    @Test
    public void removeSimpleCycle() {
        SimpleDirectedGraph graph = new SimpleDirectedGraph(DefaultEdge.class);
        graph.addVertex((Object)"A");
        graph.addVertex((Object)"B");
        graph.addEdge((Object)"A", (Object)"B");
        graph.addEdge((Object)"B", (Object)"A");
        graph = new GraphCycleRemover((Graph)graph, String.CASE_INSENSITIVE_ORDER).removeCycles();
        ArrayList vertexDependencyOrder = new ArrayList();
        new TopologicalOrderIterator((Graph)graph).forEachRemaining(vertex -> vertexDependencyOrder.add(vertex));
        Collections.reverse(vertexDependencyOrder);
        MatcherAssert.assertThat(vertexDependencyOrder, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"B", "A"}));
    }

    @Test
    public void nestedCycles() {
        SimpleDirectedGraph graph = new SimpleDirectedGraph(DefaultEdge.class);
        graph.addVertex((Object)"A");
        graph.addVertex((Object)"B");
        graph.addVertex((Object)"C");
        graph.addVertex((Object)"D");
        graph.addEdge((Object)"A", (Object)"B");
        graph.addEdge((Object)"B", (Object)"C");
        graph.addEdge((Object)"C", (Object)"D");
        graph.addEdge((Object)"D", (Object)"B");
        graph.addEdge((Object)"B", (Object)"A");
        graph = new GraphCycleRemover((Graph)graph, String.CASE_INSENSITIVE_ORDER).removeCycles();
        ArrayList vertexDependencyOrder = new ArrayList();
        new TopologicalOrderIterator((Graph)graph).forEachRemaining(vertex -> vertexDependencyOrder.add(vertex));
        Collections.reverse(vertexDependencyOrder);
        MatcherAssert.assertThat(vertexDependencyOrder, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"D", "C", "B", "A"}));
    }

    @Test
    public void subGraphsWithCycles() {
        SimpleDirectedGraph graph = new SimpleDirectedGraph(DefaultEdge.class);
        graph.addVertex((Object)"A");
        graph.addVertex((Object)"B");
        graph.addVertex((Object)"C");
        graph.addVertex((Object)"D");
        graph.addVertex((Object)"E");
        graph.addVertex((Object)"F");
        graph.addEdge((Object)"A", (Object)"B");
        graph.addEdge((Object)"B", (Object)"C");
        graph.addEdge((Object)"C", (Object)"A");
        graph.addEdge((Object)"D", (Object)"E");
        graph.addEdge((Object)"E", (Object)"F");
        graph.addEdge((Object)"F", (Object)"D");
        graph = new GraphCycleRemover((Graph)graph, String.CASE_INSENSITIVE_ORDER).removeCycles();
        ArrayList vertexDependencyOrder = new ArrayList();
        new TopologicalOrderIterator((Graph)graph).forEachRemaining(vertex -> vertexDependencyOrder.add(vertex));
        Collections.reverse(vertexDependencyOrder);
        MatcherAssert.assertThat(graph.edgeSet().stream().map(vertex -> vertex.toString()).collect(Collectors.toList()), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"(A : B)", "(B : C)", "(D : E)", "(E : F)"}));
        MatcherAssert.assertThat(vertexDependencyOrder, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"F", "C", "E", "B", "D", "A"}));
    }

    @Test
    public void subGraphsWithCyclesReverseOrder() {
        SimpleDirectedGraph graph = new SimpleDirectedGraph(DefaultEdge.class);
        graph.addVertex((Object)"A");
        graph.addVertex((Object)"B");
        graph.addVertex((Object)"C");
        graph.addVertex((Object)"D");
        graph.addVertex((Object)"E");
        graph.addVertex((Object)"F");
        graph.addEdge((Object)"A", (Object)"B");
        graph.addEdge((Object)"B", (Object)"C");
        graph.addEdge((Object)"C", (Object)"A");
        graph.addEdge((Object)"D", (Object)"E");
        graph.addEdge((Object)"E", (Object)"F");
        graph.addEdge((Object)"F", (Object)"D");
        graph = new GraphCycleRemover((Graph)graph, String.CASE_INSENSITIVE_ORDER.reversed()).removeCycles();
        ArrayList vertexDependencyOrder = new ArrayList();
        new TopologicalOrderIterator((Graph)graph).forEachRemaining(vertex -> vertexDependencyOrder.add(vertex));
        Collections.reverse(vertexDependencyOrder);
        MatcherAssert.assertThat(graph.edgeSet().stream().map(vertex -> vertex.toString()).collect(Collectors.toList()), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"(A : B)", "(C : A)", "(D : E)", "(F : D)"}));
        MatcherAssert.assertThat(vertexDependencyOrder, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"E", "B", "D", "A", "F", "C"}));
    }

    @Test
    public void subGraphsWithCyclesReferencesBetweenSubCycles() {
        SimpleDirectedGraph graph = new SimpleDirectedGraph(DefaultEdge.class);
        graph.addVertex((Object)"A");
        graph.addVertex((Object)"B");
        graph.addVertex((Object)"C");
        graph.addVertex((Object)"D");
        graph.addVertex((Object)"E");
        graph.addVertex((Object)"F");
        graph.addEdge((Object)"A", (Object)"B");
        graph.addEdge((Object)"B", (Object)"C");
        graph.addEdge((Object)"C", (Object)"A");
        graph.addEdge((Object)"D", (Object)"E");
        graph.addEdge((Object)"E", (Object)"F");
        graph.addEdge((Object)"F", (Object)"D");
        graph.addEdge((Object)"B", (Object)"F");
        graph = new GraphCycleRemover((Graph)graph, String.CASE_INSENSITIVE_ORDER).removeCycles();
        ArrayList vertexDependencyOrder = new ArrayList();
        new TopologicalOrderIterator((Graph)graph).forEachRemaining(vertex -> vertexDependencyOrder.add(vertex));
        Collections.reverse(vertexDependencyOrder);
        MatcherAssert.assertThat(vertexDependencyOrder, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"F", "C", "E", "B", "D", "A"}));
    }

    @Test
    public void subGraphsWithCyclesReferencesBetweenSubCyclesReverseOrder() {
        SimpleDirectedGraph graph = new SimpleDirectedGraph(DefaultEdge.class);
        graph.addVertex((Object)"A");
        graph.addVertex((Object)"B");
        graph.addVertex((Object)"C");
        graph.addVertex((Object)"D");
        graph.addVertex((Object)"E");
        graph.addVertex((Object)"F");
        graph.addEdge((Object)"A", (Object)"B");
        graph.addEdge((Object)"B", (Object)"C");
        graph.addEdge((Object)"C", (Object)"A");
        graph.addEdge((Object)"D", (Object)"E");
        graph.addEdge((Object)"E", (Object)"F");
        graph.addEdge((Object)"F", (Object)"D");
        graph.addEdge((Object)"B", (Object)"F");
        graph = new GraphCycleRemover((Graph)graph, String.CASE_INSENSITIVE_ORDER.reversed()).removeCycles();
        ArrayList vertexDependencyOrder = new ArrayList();
        new TopologicalOrderIterator((Graph)graph).forEachRemaining(vertex -> vertexDependencyOrder.add(vertex));
        Collections.reverse(vertexDependencyOrder);
        MatcherAssert.assertThat(vertexDependencyOrder, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"E", "D", "F", "B", "A", "C"}));
    }

    @Test
    public void noCyclesNestedDependency() {
        SimpleDirectedGraph graph = new SimpleDirectedGraph(DefaultEdge.class);
        graph.addVertex((Object)"A");
        graph.addVertex((Object)"B");
        graph.addVertex((Object)"C");
        graph.addEdge((Object)"A", (Object)"C");
        graph.addEdge((Object)"A", (Object)"B");
        graph.addEdge((Object)"B", (Object)"C");
        graph = new GraphCycleRemover((Graph)graph, String.CASE_INSENSITIVE_ORDER).removeCycles();
        ArrayList vertexDependencyOrder = new ArrayList();
        new TopologicalOrderIterator((Graph)graph).forEachRemaining(vertex -> vertexDependencyOrder.add(vertex));
        Collections.reverse(vertexDependencyOrder);
        MatcherAssert.assertThat(vertexDependencyOrder, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"C", "B", "A"}));
    }
}

