/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.ast.test.internal;

import static org.mule.runtime.ast.api.ArtifactType.APPLICATION;

import static java.util.Arrays.asList;
import static java.util.Collections.emptyList;
import static java.util.Collections.emptySet;
import static java.util.Optional.empty;

import static org.mockito.Mockito.mock;

import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ArtifactType;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ImportedResource;
import org.mule.runtime.ast.api.util.BaseArtifactAst;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;


public class TestArtifactAst extends BaseArtifactAst {

  private final List<ComponentAst> topLevel;

  public TestArtifactAst(ComponentAst... topLevelComponents) {
    this.topLevel = asList(topLevelComponents);
  }

  @Override
  public String getArtifactName() {
    return "myApp";
  }

  @Override
  public ArtifactType getArtifactType() {
    return APPLICATION;
  }

  @Override
  public Set<ExtensionModel> dependencies() {
    return emptySet();
  }

  @Override
  public Optional<ArtifactAst> getParent() {
    return empty();
  }

  @Override
  public List<ComponentAst> topLevelComponents() {
    return topLevel;
  }

  @Override
  public void updatePropertiesResolver(UnaryOperator<String> newPropertiesResolver) {
    // nothing to do
  }

  @Override
  public ErrorTypeRepository getErrorTypeRepository() {
    return mock(ErrorTypeRepository.class);
  }

  @Override
  public Collection<ImportedResource> getImportedResources() {
    return emptyList();
  }
}
